/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.impl;

import java.util.concurrent.locks.LockSupport;

public class BackOffStrategy {
    int yieldCount;
    int parkCount;
    int sleepCount;
    int nanosToPark = 300000;

    public BackOffStrategy() {
        this.setCounters(5000, 1000, 10);
    }

    public BackOffStrategy(int spinUntilYield, int yieldUntilPark, int parkUntilSleep) {
        this.setCounters(spinUntilYield, yieldUntilPark, parkUntilSleep);
    }

    public void setCounters(int spinUntilYield, int yieldUntilPark, int parkUntilSleep) {
        this.yieldCount = spinUntilYield;
        this.parkCount = spinUntilYield + yieldUntilPark;
        this.sleepCount = spinUntilYield + yieldUntilPark + parkUntilSleep;
    }

    public int getNanosToPark() {
        return this.nanosToPark;
    }

    public void setNanosToPark(int nanosToPark) {
        this.nanosToPark = nanosToPark;
    }

    public void yield(int count) {
        if (count > this.sleepCount || count < 0) {
            LockSupport.parkNanos(this.nanosToPark);
        } else if (count > this.parkCount) {
            LockSupport.parkNanos(1L);
        } else if (count > this.yieldCount) {
            Thread.yield();
        }
    }

    public boolean isSleeping(int yieldCount) {
        return yieldCount > this.sleepCount;
    }

    public boolean isYielding(int count) {
        return count > this.yieldCount;
    }
}

