/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.minbingen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.minbingen.GenContext;
import org.nustaq.kontraktor.remoting.minbingen.MsgInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.minbin.GenMeta;

public abstract class AbstractGen {
    protected FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    protected HashSet<String> clazzSet = new HashSet();
    protected HashMap<Class, List<MsgInfo>> infoMap = new HashMap();

    public void addTopLevelClass(String clazzName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.conf.setForceSerializable(true);
        Class<?> c = Class.forName(clazzName);
        try {
            if (Actor.class.isAssignableFrom(c)) {
                this.prepareActorMeta(c);
            } else if (GenMeta.class.isAssignableFrom(c)) {
                GenMeta meta = (GenMeta)c.newInstance();
                List clazz = meta.getClasses();
                for (int i = 0; i < clazz.size(); ++i) {
                    Class aClass = (Class)clazz.get(i);
                    this.addClz(this.clazzSet, aClass, this.infoMap);
                }
            } else {
                this.addClz(this.clazzSet, c, this.infoMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    protected void generate(String outFile) throws Exception {
        System.out.println("generating to " + new File(outFile).getAbsolutePath());
        GenContext ctx = new GenContext();
        this.genClzList(outFile, new ArrayList<String>(this.clazzSet), ctx, this.infoMap, this.getTemplateFileOrClazz());
        try {
            File f = new File(outFile);
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            f = new File(f, "name-map.kson");
            PrintStream pout = new PrintStream(new FileOutputStream(f));
            pout.println("{");
            this.clazzSet.stream().forEach(clzStr -> {
                Class<?> clz = null;
                try {
                    clz = Class.forName(clzStr);
                    String simpleName = clz.getSimpleName();
                    while (simpleName.length() < 20) {
                        simpleName = simpleName + " ";
                    }
                    pout.println("    " + simpleName + " : '" + clz.getName() + "'");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            });
            pout.println("}");
            pout.flush();
            pout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void addClz(Set<String> clazzSet, Class aClass, HashMap<Class, List<MsgInfo>> infoMap) {
        if (!clazzSet.contains(aClass.getName())) {
            if (aClass.getName().startsWith("java.") || aClass.getName().startsWith("javax.")) {
                return;
            }
            if (Actor.class.isAssignableFrom(aClass)) {
                this.prepareActorMeta(aClass);
            } else {
                clazzSet.add(aClass.getName());
            }
        }
    }

    private void prepareActorMeta(Class c) {
        this.clazzSet.add(c.getName());
        Method[] m = c.getMethods();
        ArrayList<MsgInfo> methodInfos = new ArrayList<MsgInfo>();
        for (int i = 0; i < m.length; ++i) {
            Type genericReturnType;
            Method method = m[i];
            if (!Modifier.isPublic(method.getModifiers()) || method.getAnnotation(CallerSideMethod.class) != null || method.getAnnotation(Local.class) != null || method.getReturnType() != Void.TYPE && !Future.class.isAssignableFrom(method.getReturnType()) || method.getDeclaringClass() == Object.class || Modifier.isStatic(method.getModifiers())) continue;
            Class[] parameterTypes = method.getParameterTypes();
            Parameter[] parameters = method.getParameters();
            methodInfos.add(new MsgInfo(parameterTypes, method.getName(), method.getReturnType().getSimpleName(), parameters));
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class parameterType = parameterTypes[j];
                if (!this.shouldAdd(parameterType)) continue;
                this.addClz(this.clazzSet, parameterType, this.infoMap);
            }
            if (Future.class.isAssignableFrom(method.getReturnType()) && (genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType) {
                ParameterizedType pm = (ParameterizedType)genericReturnType;
                Type[] actualTypeArguments = pm.getActualTypeArguments();
                Type clz = actualTypeArguments[0];
                if (actualTypeArguments.length > 0 && clz instanceof Class && this.shouldAdd((Class)clz)) {
                    this.addClz(this.clazzSet, (Class)clz, this.infoMap);
                }
            }
            System.out.println("method:" + method);
        }
        this.infoMap.put(c, methodInfos);
    }

    private boolean shouldAdd(Class<?> parameterType) {
        return !Callback.class.isAssignableFrom(parameterType) && !parameterType.isPrimitive() && (!parameterType.isArray() || !parameterType.getComponentType().isPrimitive()) && !String.class.isAssignableFrom(parameterType) && !parameterType.isArray() && !Number.class.isAssignableFrom(parameterType);
    }

    protected abstract void genClzList(String var1, ArrayList<String> var2, GenContext var3, HashMap<Class, List<MsgInfo>> var4, String var5) throws Exception;

    public abstract String getTemplateFileOrClazz();
}

