/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.Future;

public class FutureLatch<T> {
    Future<T> wrapped;
    AtomicInteger count;

    public FutureLatch(Future<T> wrapped) {
        this.wrapped = wrapped;
        this.count = new AtomicInteger(1);
    }

    public FutureLatch(Future<T> wrapped, int counter) {
        this.wrapped = wrapped;
        this.count = new AtomicInteger(counter);
    }

    public void receive(T result, Object error) {
        this.countDown(result, error);
    }

    public void countDown(T result, Object error) {
        int i = this.count.decrementAndGet();
        if (i == 0) {
            this.wrapped.receive(result, error);
        } else if (i < 0) {
            throw new RuntimeException("latch already triggered !");
        }
    }

    public void countUp(int amount) {
        this.count.incrementAndGet();
    }

    public int getCount() {
        return this.count.get();
    }
}

