/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.annotations.CallerSideMethod;

public class Log
extends Actor<Log> {
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static Log Lg = (Log)Actors.AsActor(Log.class, 100000);
    LogWrapper logger = new LogWrapper(){
        DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");

        @Override
        public void msg(Thread t, int sev, Object source, Throwable ex, String msg) {
            if (Log.this.severity <= sev) {
                source = source == null ? "NULL" : source.getClass().getSimpleName();
                String tname = t == null ? "-" : t.getName();
                String svString = "";
                switch (sev) {
                    case 2: {
                        svString = "! ";
                        break;
                    }
                    case 3: {
                        svString = "!! ";
                    }
                }
                System.out.println(svString + this.formatter.format(new Date()) + " : " + tname + " : " + source + " : " + msg);
                if (ex != null) {
                    if (sev == 1) {
                        System.out.println(ex.toString());
                    } else {
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }
    };
    int severity = 0;

    public static void Info(Object source, String msg) {
        Lg.info(source, msg);
    }

    public static void Warn(Object source, Throwable t, String msg) {
        Lg.warnLong(source, t, msg);
    }

    public static void Warn(Object source, String msg) {
        Lg.warnLong(source, null, msg);
    }

    public static void Warn(Object source, Exception ex) {
        Lg.warnLong(source, ex, null);
    }

    public void $init(LogWrapper delegate) {
        this.logger = delegate;
    }

    public void $setSeverity(int severity) {
        this.severity = severity;
    }

    @CallerSideMethod
    public void infoLong(Object source, Throwable ex, String msg) {
        this.$msg(Thread.currentThread(), 1, source, ex, msg);
    }

    @CallerSideMethod
    public void info(Object source, String msg) {
        this.$msg(Thread.currentThread(), 1, source, null, msg);
    }

    @CallerSideMethod
    public void warnLong(Object source, Throwable ex, String msg) {
        this.$msg(Thread.currentThread(), 2, source, ex, msg);
    }

    @CallerSideMethod
    public void warn(Object source, String msg) {
        this.$msg(Thread.currentThread(), 2, source, null, msg);
    }

    @CallerSideMethod
    public void error(Object source, Throwable ex, String msg) {
        this.$msg(Thread.currentThread(), 3, source, ex, msg);
    }

    public void $msg(Thread t, int severity, Object source, Throwable ex, String msg) {
        this.logger.msg(t, severity, source, ex, msg);
    }

    public static interface LogWrapper {
        public void msg(Thread var1, int var2, Object var3, Throwable var4, String var5);
    }
}

