/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.locks.LockSupport;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.remoting.http.KontraktorHttpRequest;
import org.nustaq.kontraktor.remoting.http.KontraktorHttpRequestImpl;
import org.nustaq.kontraktor.remoting.http.NioHttpServer;
import org.nustaq.kontraktor.remoting.http.RequestProcessor;
import org.nustaq.kontraktor.remoting.http.RequestResponse;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.RateMeasure;
import org.nustaq.serialization.util.FSTUtil;

public class NioHttpServerImpl
extends Actor<NioHttpServerImpl>
implements NioHttpServer {
    ServerSocketChannel socket;
    Selector selector;
    SelectionKey serverkey;
    ByteBuffer buffer = ByteBuffer.allocate(0x100000);
    int port;
    RequestProcessor processor;
    boolean shouldTerminate = false;
    long lastRequest;
    RateMeasure reqPerS = new RateMeasure("req/s", 5000L);

    @Override
    public void $init(int port, RequestProcessor processor) {
        Thread.currentThread().setName("NioHttp");
        this.port = port;
        this.processor = processor;
        try {
            this.selector = Selector.open();
            this.socket = ServerSocketChannel.open();
            this.socket.socket().bind(new InetSocketAddress(port));
            this.socket.configureBlocking(false);
            this.serverkey = this.socket.register(this.selector, 16);
            this.info("bound to port " + port);
        }
        catch (IOException e) {
            this.severe("could not bind to port" + port);
            Log.Lg.error(this, e, null);
        }
    }

    protected void severe(String s) {
        Log.Lg.error(this, null, s);
    }

    protected void info(String s) {
        Log.Info(this, s);
    }

    @Override
    public void $receive() {
        try {
            this.selector.selectNow();
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey key = iterator.next();
                try {
                    if (key == this.serverkey) {
                        SocketChannel accept;
                        if (!key.isAcceptable() || (accept = this.socket.accept()) == null) continue;
                        accept.configureBlocking(false);
                        accept.register(this.selector, 1);
                        this.lastRequest = System.currentTimeMillis();
                        continue;
                    }
                    SocketChannel client = (SocketChannel)key.channel();
                    if (!key.isReadable()) continue;
                    iterator.remove();
                    try {
                        this.service(key, client);
                    }
                    catch (IOException ioe) {
                        key.cancel();
                        client.close();
                        throw ioe;
                    }
                }
                catch (Throwable e) {
                    Log.Warn(this, e, "");
                }
            }
        }
        catch (Throwable e) {
            Log.Warn(this, e, "");
        }
        if (!this.shouldTerminate) {
            if (System.currentTimeMillis() - this.lastRequest > 100L) {
                LockSupport.parkNanos(1000000L);
            }
            ((NioHttpServerImpl)this.self()).$receive();
        }
    }

    @Override
    @CallerSideMethod
    public Actor getServingActor() {
        return this;
    }

    @Override
    public void $addHttpProcessor(RequestProcessor restProcessor) {
        if (this.processor != null && restProcessor != this.processor) {
            Log.Warn((Object)this, "httpprocessor already set");
        }
        this.processor = restProcessor;
    }

    public void $stopService() {
        this.shouldTerminate = true;
    }

    protected void service(SelectionKey key, SocketChannel client) throws IOException {
        if (!client.isOpen()) {
            key.cancel();
            client.close();
            return;
        }
        int bytesread = client.read(this.buffer);
        if (bytesread == -1) {
            key.cancel();
            client.close();
        } else {
            this.buffer.flip();
            this.reqPerS.count();
            KontraktorHttpRequest request = (KontraktorHttpRequest)key.attachment();
            if (request == null) {
                request = new KontraktorHttpRequestImpl(this.buffer, bytesread);
            } else {
                request.append(this.buffer, bytesread);
            }
            if (!request.isComplete()) {
                key.attach(request);
            } else {
                key.attach(null);
                if (this.processor != null) {
                    try {
                        this.processor.processRequest(request, (result, error) -> {
                            if (error == null || error == "FIN") {
                                try {
                                    if (result != null) {
                                        this.writeClient(client, ByteBuffer.wrap(result.getBinary()));
                                    }
                                }
                                catch (Exception e) {
                                    Log.Warn(this, e, "");
                                }
                            }
                            if (error != null) {
                                try {
                                    if (error != "FIN") {
                                        if (error instanceof Throwable) {
                                            this.writeClient(client, ByteBuffer.wrap(FSTUtil.toString((Throwable)((Throwable)error)).getBytes()));
                                        } else {
                                            this.writeClient(client, ByteBuffer.wrap(error.toString().getBytes()));
                                        }
                                    }
                                    key.cancel();
                                    client.close();
                                }
                                catch (IOException e) {
                                    Log.Warn(this, e, "");
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        this.writeClient(client, ByteBuffer.wrap(FSTUtil.toString((Throwable)ex).getBytes()));
                        key.cancel();
                        client.close();
                    }
                } else {
                    key.cancel();
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        Log.Warn(this, e, "");
                    }
                }
            }
            this.buffer.clear();
        }
    }

    private void writeClient(SocketChannel client, ByteBuffer wrap) throws IOException {
        while (wrap.remaining() > 0) {
            client.write(wrap);
        }
    }

    public static void main(String[] arg) throws InterruptedException {
        NioHttpServerImpl server = (NioHttpServerImpl)Actors.AsActor(NioHttpServerImpl.class);
        server.$init(9999, new SimpleProcessor());
        server.$receive();
    }

    static class SimpleProcessor
    implements RequestProcessor {
        SimpleProcessor() {
        }

        public boolean processRequest(KontraktorHttpRequest req, Callback response) {
            response.receive(new RequestResponse("HTTP/1.0 200 OK\nAccess-Control-Allow-Origin: *\n\n" + req.getText()), null);
            response.receive(null, "FIN");
            return true;
        }
    }
}

