/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import org.nustaq.kontraktor.remoting.http.rest.HtmlString;

public class RequestResponse {
    public static final RequestResponse MSG_403 = new RequestResponse("HTTP/1.0 403 forbidden\n\n403 no no"){

        @Override
        public int getStatusCode() {
            return 403;
        }
    };
    public static final RequestResponse MSG_404 = new RequestResponse("HTTP/1.0 404 not found\n\n404 nope"){

        @Override
        public int getStatusCode() {
            return 404;
        }
    };
    public static final RequestResponse MSG_500 = new RequestResponse("HTTP/1.0 500 internal error\n\n500 something went wrong somewhere"){

        @Override
        public int getStatusCode() {
            return 500;
        }
    };
    public static final RequestResponse MSG_200 = new RequestResponse("HTTP/1.0 200 OK\nAccess-Control-Allow-Origin: *\n\n"){

        @Override
        public int getStatusCode() {
            return 200;
        }
    };
    String data;
    HtmlString htmlData;
    byte[] binary;
    String location;

    public static final RequestResponse MSG_302(String s) {
        RequestResponse requestResponse = new RequestResponse("HTTP/1.0 302 FOUND\nLocation: " + s + "\n\n"){

            @Override
            public int getStatusCode() {
                return 302;
            }
        };
        requestResponse.setLocation(s);
        return requestResponse;
    }

    public RequestResponse(String data) {
        this.data = data;
    }

    public RequestResponse(HtmlString data) {
        this.htmlData = data;
    }

    public RequestResponse(byte[] data) {
        this.binary = data;
    }

    public byte[] getBinary() {
        if (this.binary != null) {
            return this.binary;
        }
        return this.data.getBytes();
    }

    public boolean isHtml() {
        return this.htmlData != null;
    }

    public int getStatusCode() {
        return -1;
    }

    public String toString() {
        return this.binary != null ? new String(this.binary, 0) : (this.htmlData != null ? this.htmlData.getString() : this.data);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

