/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import java.io.IOException;
import java.net.SocketException;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.RemoteConnection;
import org.nustaq.kontraktor.impl.BackOffStrategy;
import org.nustaq.kontraktor.impl.RemoteScheduler;
import org.nustaq.kontraktor.remoting.ObjectSocket;
import org.nustaq.kontraktor.remoting.RemoteRefRegistry;
import org.nustaq.kontraktor.remoting.tcp.TCPSocket;
import org.nustaq.kontraktor.util.Log;

public class TCPActorClient<T extends Actor>
extends RemoteRefRegistry {
    Class<? extends Actor> actorClazz;
    T facadeProxy;
    BackOffStrategy backOffStrategy = new BackOffStrategy();
    String host;
    int port;
    ActorClient client;
    volatile boolean connected = false;

    public static <AC extends Actor> Future<AC> Connect(Class<AC> clz, String host, int port) throws IOException {
        return TCPActorClient.Connect(clz, host, port, null);
    }

    public static <AC extends Actor> Future<AC> Connect(Class<AC> clz, String host, int port, Consumer<Actor> disconnectHandler) throws IOException {
        if (disconnectHandler != null) {
            disconnectHandler = Actors.InThread(disconnectHandler);
        }
        Promise res = new Promise();
        TCPActorClient client = new TCPActorClient(clz, host, port);
        if (disconnectHandler != null) {
            client.setDisconnectHandler(disconnectHandler);
        }
        new Thread(() -> {
            try {
                client.connect();
                res.receive(client.getFacadeProxy(), (Object)null);
            }
            catch (IOException e) {
                Log.Warn(TCPActorClient.class, null, "" + e);
                res.receive((Object)null, (Object)e);
            }
        }, "connect " + super.getDescriptionString()).start();
        return res;
    }

    public TCPActorClient(Class<? extends Actor> clz, String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.actorClazz = clz;
        this.facadeProxy = Actors.AsActor(this.actorClazz, new RemoteScheduler());
        ((Actor)this.facadeProxy).__remoteId = 1;
        this.registerRemoteRefDirect((Actor)this.facadeProxy);
    }

    public T getFacadeProxy() {
        return this.facadeProxy;
    }

    public void connect() throws IOException {
        this.client = new ActorClient();
        this.connected = true;
        ((Actor)this.facadeProxy).__addRemoteConnection(this.client);
    }

    private String getDescriptionString() {
        return this.actorClazz.getSimpleName() + "@" + this.host + ":" + this.port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    protected void remoteRefStopped(Actor actor) {
        super.remoteRefStopped(actor);
        if (actor.getActorRef() == ((Actor)this.facadeProxy).getActorRef()) {
            this.setTerminated(true);
            this.stopRemoteRefs();
            this.client.close();
        }
    }

    public class ActorClient
    implements RemoteConnection {
        ObjectSocket chan;

        public ActorClient() throws IOException {
            this.chan = new TCPSocket(TCPActorClient.this.host, TCPActorClient.this.port, TCPActorClient.this.conf);
            new Thread(() -> {
                TCPActorClient.this.currentObjectSocket.set(this.chan);
                try {
                    TCPActorClient.this.sendLoop(this.chan);
                }
                catch (IOException e) {
                    if (e instanceof SocketException) {
                        Log.Lg.infoLong(this, e, "");
                    }
                    Log.Warn(this, e, "");
                }
            }, "sender").start();
            new Thread(() -> {
                TCPActorClient.this.currentObjectSocket.set(this.chan);
                TCPActorClient.this.receiveLoop(this.chan);
            }, "receiver").start();
        }

        @Override
        public void close() {
            try {
                this.chan.close();
            }
            catch (IOException e) {
                Log.Warn(this, e, "");
            }
        }
    }
}

