/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.impl.ActorsImpl;
import org.nustaq.kontraktor.impl.DispatcherThread;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.kontraktor.util.Log;

public class Actors {
    public static int MAX_EXTERNAL_THREADS_POOL_SIZE = 1000;
    public static int DEFAULT_TIMOUT = 15000;
    public static ThreadPoolExecutor exec = new ThreadPoolExecutor(MAX_EXTERNAL_THREADS_POOL_SIZE, MAX_EXTERNAL_THREADS_POOL_SIZE, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    public static ActorsImpl instance;
    public static Timer delayedCalls;
    public static Supplier<Scheduler> defaultScheduler;
    public static final String FINSILENT = "EOT";
    public static final String CONT = "CNT";
    public static final String FIN = "FIN";

    public static boolean isFinal(Object error) {
        return FIN.equals(error) || FINSILENT.equals(error) || !CONT.equals(error);
    }

    public static boolean isSilentFinal(Object o) {
        return FINSILENT.equals(o);
    }

    public static boolean isCont(Object o) {
        return CONT.equals(o);
    }

    public static boolean isResult(Object error) {
        return error == null || Actors.isCont(error);
    }

    public static boolean isError(Object o) {
        return o != null && !FIN.equals(o) && !FINSILENT.equals(o) && !CONT.equals(o);
    }

    public static void SubmitDelayed(long millis, final Runnable task) {
        delayedCalls.schedule(new TimerTask(){

            @Override
            public void run() {
                task.run();
            }
        }, millis);
    }

    public static void AddDeadLetter(String s) {
        Log.Lg.warn(null, s);
        Actors.DeadLetters().add(s);
    }

    public static <T> T InThread(T anInterface) {
        Actor sender = Actor.sender.get();
        if (sender != null) {
            return sender.getScheduler().inThread((Actor)sender.getActor(), anInterface);
        }
        return anInterface;
    }

    public static ConcurrentLinkedQueue<String> DeadLetters() {
        return instance.getDeadLetters();
    }

    public static <T extends Actor> T AsActor(Class<T> actorClazz) {
        return (T)instance.newProxy(actorClazz, defaultScheduler.get(), -1);
    }

    public static <T extends Actor> T AsActor(Class<T> actorClazz, int qSize) {
        return (T)instance.newProxy(actorClazz, defaultScheduler.get(), qSize);
    }

    public static <T extends Actor> T AsActor(Class<T> actorClazz, Scheduler scheduler) {
        return (T)instance.newProxy(actorClazz, scheduler, -1);
    }

    public static <T extends Actor> T AsActor(Class<T> actorClazz, Scheduler scheduler, int qsize) {
        return (T)instance.newProxy(actorClazz, scheduler, qsize);
    }

    public static <T> IPromise<IPromise<T>[]> all(IPromise<T> ... futures) {
        Promise<IPromise<T>[]> res = new Promise<IPromise<T>[]>();
        Actors.awaitSettle(futures, 0, res);
        return res;
    }

    public static <T> IPromise<List<IPromise<T>>> all(List<IPromise<T>> futures) {
        Promise<List<IPromise<T>>> res = new Promise<List<IPromise<T>>>();
        Actors.awaitSettle(futures, 0, res);
        return res;
    }

    public static <T> Stream<T> awaitAll(long timeoutMS, IPromise<T> ... futures) {
        return Actors.streamHelper(Actors.all(futures).await(timeoutMS));
    }

    public static <T> Stream<T> awaitAll(IPromise<T> ... futures) {
        return Actors.streamHelper(Actors.all(futures).await());
    }

    public static <T> Stream<T> awaitAll(List<IPromise<T>> futures) {
        return Actors.streamHelper(Actors.all(futures).await());
    }

    public static <T> Stream<T> awaitAll(long timeoutMS, List<IPromise<T>> futures) {
        return Actors.streamHelper(Actors.all(futures).await(timeoutMS));
    }

    public static <T> IPromise<T> race(IPromise<T> ... futures) {
        Promise p = new Promise();
        AtomicBoolean fin = new AtomicBoolean(false);
        for (int i = 0; i < futures.length; ++i) {
            futures[i].then((r, e) -> {
                if (fin.compareAndSet(false, true)) {
                    p.complete(r, e);
                }
            });
        }
        return p;
    }

    public static <T> IPromise<T> race(Collection<IPromise<T>> futures) {
        Promise p = new Promise();
        AtomicBoolean fin = new AtomicBoolean(false);
        Iterator<IPromise<T>> iterator = futures.iterator();
        while (iterator.hasNext()) {
            iterator.next().then((r, e) -> {
                if (fin.compareAndSet(false, true)) {
                    p.complete(r, e);
                }
            });
        }
        return p;
    }

    public static <T> Stream<T> stream(T ... t) {
        return Arrays.stream(t);
    }

    public static <T> IPromise<T> resolve(T res) {
        return new Promise<T>(res);
    }

    public static <T> IPromise<T> reject(Object err) {
        return new Promise<Object>(null, err);
    }

    public static <T> IPromise<T> complete(T res, Object err) {
        return new Promise<T>(res, err);
    }

    public static IPromise complete() {
        return new Promise<String>("dummy");
    }

    public static IPromise resolve() {
        return new Promise<String>("dummy");
    }

    public static void yield() {
        Actors.yield(0L);
    }

    public static void yield(long timeout) {
        block8: {
            block7: {
                long endtime = 0L;
                if (timeout > 0L) {
                    endtime = System.currentTimeMillis() + timeout;
                }
                if (!(Thread.currentThread() instanceof DispatcherThread)) break block7;
                DispatcherThread dt = (DispatcherThread)Thread.currentThread();
                Scheduler scheduler = dt.getScheduler();
                boolean term = false;
                int idleCount = 0;
                while (!term) {
                    boolean hadSome = dt.pollQs();
                    if (!hadSome) {
                        scheduler.pollDelay(++idleCount);
                        if (endtime == 0L) {
                            term = true;
                        }
                    } else {
                        idleCount = 0;
                    }
                    if (endtime == 0L || System.currentTimeMillis() <= endtime) continue;
                    term = true;
                }
                break block8;
            }
            if (timeout <= 0L) break block8;
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T> void awaitSettle(IPromise<T>[] futures, int index, IPromise result) {
        if (index < futures.length) {
            futures[index].then((r, e) -> Actors.awaitSettle(futures, index + 1, result));
        } else {
            result.complete(futures, null);
        }
    }

    private static <T> void awaitSettle(List<IPromise<T>> futures, int index, IPromise result) {
        if (index < futures.size()) {
            futures.get(index).then((r, e) -> Actors.awaitSettle(futures, index + 1, result));
        } else {
            result.complete(futures, null);
        }
    }

    private static <T> Stream<T> streamHelper(IPromise<T> ... completedPromises) {
        return Arrays.stream(completedPromises).map(future -> future.get());
    }

    private static <T> Stream<T> streamHelper(List<IPromise<T>> completedPromises) {
        return completedPromises.stream().map(future -> future.get());
    }

    static {
        exec.allowCoreThreadTimeOut(true);
        instance = new ActorsImpl();
        delayedCalls = new Timer();
        defaultScheduler = () -> new SimpleScheduler();
    }
}

