/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.encoding;

import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.serialization.FSTConfiguration;

public class Coding {
    SerializerType coding;
    Class[] crossPlatformShortClazzNames;

    public Coding(SerializerType coding) {
        this.coding = coding;
    }

    public Coding(SerializerType coding, Class[] crossPlatformShortClazzNames) {
        this.coding = coding;
        this.crossPlatformShortClazzNames = crossPlatformShortClazzNames;
    }

    public Class[] getCrossPlatformShortClazzNames() {
        return this.crossPlatformShortClazzNames;
    }

    public SerializerType getCoding() {
        return this.coding;
    }

    public FSTConfiguration createConf() {
        FSTConfiguration conf;
        switch (this.coding) {
            case MinBin: {
                conf = FSTConfiguration.createMinBinConfiguration();
                break;
            }
            case Json: {
                conf = FSTConfiguration.createJsonConfiguration();
                break;
            }
            case JsonNoRef: {
                conf = FSTConfiguration.createJsonConfiguration((boolean)false, (boolean)false);
                break;
            }
            case JsonNoRefPretty: {
                conf = FSTConfiguration.createJsonConfiguration((boolean)true, (boolean)false);
                break;
            }
            case UnsafeBinary: {
                conf = FSTConfiguration.createFastBinaryConfiguration();
                break;
            }
            case FSTSer: {
                conf = FSTConfiguration.createDefaultConfiguration();
                break;
            }
            default: {
                throw new RuntimeException("unknown ser configuration type");
            }
        }
        return conf;
    }
}

