/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.tcp;

import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorClient;
import org.nustaq.kontraktor.remoting.base.ActorClientConnector;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.tcp.TCPClientConnector;

public class TCPConnectable
implements ConnectableActor {
    String host;
    int port;
    Class actorClz;
    Coding coding = new Coding(SerializerType.FSTSer);

    public TCPConnectable() {
    }

    public TCPConnectable(Class actorClz, String host, int port) {
        this.host = host;
        this.port = port;
        this.actorClz = actorClz;
    }

    @Override
    public <T> IPromise<T> connect(Callback<ActorClientConnector> disconnectCallback) {
        Promise result = new Promise();
        Runnable connect = () -> {
            TCPClientConnector client = new TCPClientConnector(this.port, this.host, disconnectCallback);
            ActorClient connector = new ActorClient(client, this.actorClz, this.coding);
            connector.connect().then(result);
        };
        if (!Actor.inside()) {
            TCPClientConnector.get().execute(() -> Thread.currentThread().setName("singleton remote client actor polling"));
            TCPClientConnector.get().execute(connect);
        } else {
            connect.run();
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Class getActorClz() {
        return this.actorClz;
    }

    public TCPConnectable host(String host) {
        this.host = host;
        return this;
    }

    public TCPConnectable port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public TCPConnectable actorClass(Class actorClz) {
        this.actorClz = actorClz;
        return this;
    }

    public TCPConnectable coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public TCPConnectable serType(SerializerType sertype) {
        this.coding = new Coding(sertype);
        return this;
    }
}

