/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.MustBeRunFromActorThread;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.RemoteConnection;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.impl.ActorProxyFactory;
import org.nustaq.kontraktor.impl.DispatcherThread;
import org.nustaq.kontraktor.impl.InternalActorStoppedException;
import org.nustaq.kontraktor.monitoring.Monitorable;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.TicketMachine;

public class Actor<SELF extends Actor>
extends Actors
implements Serializable,
Monitorable,
Executor {
    public static ThreadLocal<Actor> sender = new ThreadLocal();
    public Queue __mailbox;
    public int __mbCapacity;
    public Queue __cbQueue;
    public Thread __currentDispatcher;
    public Scheduler __scheduler;
    public volatile boolean __stopped;
    public Actor __self;
    public int __remoteId;
    public boolean __throwExAtBlock;
    public volatile ConcurrentLinkedQueue<RemoteConnection> __connections;
    public RemoteConnection __clientConnection;
    ConcurrentLinkedQueue<Callback<SELF>> __stopHandlers;
    public int __mailboxCapacity;
    Thread _t;
    protected TicketMachine __ticketMachine;
    ConcurrentHashMap methodCache;

    public static Actor current() {
        Actor actor = sender.get();
        if (actor == null) {
            throw new MustBeRunFromActorThread();
        }
        return actor;
    }

    public static boolean inside() {
        return sender.get() != null;
    }

    public void __submit(Runnable toRun) {
        toRun.run();
    }

    protected SELF self() {
        return (SELF)this.__self;
    }

    public ActorProxyFactory getFactory() {
        return Actors.instance.getFactory();
    }

    public SELF getActor() {
        return (SELF)this;
    }

    @CallerSideMethod
    public void stop() {
        if (this.isRemote()) {
            throw new RuntimeException("Cannot stop remote ref");
        }
        ((Actor)this.self()).ping().then(() -> ((Actor)this.self()).asyncstop());
    }

    @CallerSideMethod
    public boolean isStopped() {
        return this.__stopped;
    }

    @CallerSideMethod
    public boolean isProxy() {
        return this.getActor() != this;
    }

    public IPromise ask(String messageId, Object ... args) {
        return Actor.resolve(null);
    }

    public void tell(String messageId, Object ... args) {
    }

    public <T> IPromise<T> exec(Callable<T> callable) {
        Promise prom = new Promise();
        this.__scheduler.runBlockingCall((Actor)this.self(), callable, prom);
        return prom;
    }

    @CallerSideMethod
    @Local
    public void delayed(long millis, Runnable toRun) {
        this.__scheduler.delayedCall(millis, this.inThread((Actor)this.self(), (Object)toRun));
    }

    @CallerSideMethod
    public boolean isMailboxPressured() {
        return this.__mailbox.size() * 2 > this.__mbCapacity;
    }

    @CallerSideMethod
    public Scheduler getScheduler() {
        return this.__scheduler;
    }

    @CallerSideMethod
    public boolean isCallbackQPressured() {
        return this.__cbQueue.size() * 2 > this.__mbCapacity;
    }

    @CallerSideMethod
    public int getMailboxSize() {
        return this.__mailbox.size();
    }

    @CallerSideMethod
    public int getQSizes() {
        return this.getCallbackSize() + this.getMailboxSize();
    }

    @CallerSideMethod
    public int getCallbackSize() {
        return this.__cbQueue.size();
    }

    @CallerSideMethod
    protected <T> T inThread(Actor proxy, T cbInterface) {
        return this.__scheduler.inThread(proxy, cbInterface);
    }

    protected final void checkThread() {
        if (this._t == null) {
            this._t = Thread.currentThread();
        } else if (this._t != Thread.currentThread()) {
            throw new RuntimeException("Wrong Thread");
        }
    }

    @CallerSideMethod
    public Actor getActorRef() {
        return this.__self;
    }

    @CallerSideMethod
    public boolean isRemote() {
        return this.__remoteId != 0;
    }

    @Local
    public void close() {
        if (this.__connections != null) {
            ConcurrentLinkedQueue<RemoteConnection> prevCon = this.getActorRef().__connections;
            this.getActorRef().__connections = null;
            ((Actor)this.getActor()).__connections = null;
            prevCon.forEach(con -> con.close());
        }
    }

    @Local
    public void asyncstop() {
        this.__stop();
    }

    @CallerSideMethod
    public void stopSafeClose() {
        if (this.isStopped()) {
            ((Actor)this.getActor()).close();
        } else {
            ((Actor)this.self()).close();
        }
    }

    @Local
    public IPromise ping() {
        return new Promise<String>("pong");
    }

    protected void serialOn(Object transactionKey, Consumer<IPromise> toRun) {
        if (this.isProxy()) {
            throw new RuntimeException("cannot call on actor proxy object");
        }
        if (this.__ticketMachine == null) {
            this.__ticketMachine = new TicketMachine();
        }
        this.__ticketMachine.getTicket(transactionKey).onResult(finSig -> {
            try {
                toRun.accept((IPromise)finSig);
            }
            catch (Throwable th) {
                Log.Warn((Object)this, th);
            }
        });
    }

    @CallerSideMethod
    public SELF setThrowExWhenBlocked(boolean b) {
        this.getActorRef().__throwExAtBlock = b;
        ((Actor)this.getActor()).__throwExAtBlock = b;
        return (SELF)this;
    }

    protected boolean getThrowExWhenBlocked() {
        return this.__throwExAtBlock;
    }

    @CallerSideMethod
    public boolean isPublished() {
        return this.__connections != null && this.__connections.peek() != null;
    }

    @Override
    @CallerSideMethod
    @Local
    public void execute(Runnable command) {
        ((Actor)this.self()).__submit(command);
    }

    @CallerSideMethod
    @Local
    public DispatcherThread getCurrentDispatcher() {
        return (DispatcherThread)this.__currentDispatcher;
    }

    protected ConcurrentLinkedQueue<RemoteConnection> getConnections() {
        return this.__connections;
    }

    @CallerSideMethod
    public void __addStopHandler(Callback<SELF> cb) {
        if (this.__stopHandlers == null) {
            ((Actor)this.getActor()).__stopHandlers = this.getActorRef().__stopHandlers = new ConcurrentLinkedQueue();
        }
        this.__stopHandlers.add(cb);
    }

    @CallerSideMethod
    public void __addRemoteConnection(RemoteConnection con) {
        if (this.__connections == null) {
            ((Actor)this.getActor()).__connections = this.getActorRef().__connections = new ConcurrentLinkedQueue();
        }
        if (!this.__connections.contains(con)) {
            this.__connections.add(con);
        }
    }

    @CallerSideMethod
    public void __removeRemoteConnection(RemoteConnection con) {
        if (this.__connections != null) {
            this.__connections.remove(con);
        }
    }

    @CallerSideMethod
    public void __stop() {
        Log.Debug((Object)this, "stopping actor " + this.getClass().getSimpleName());
        Actor self = this.__self;
        if (self == null || this.getActor() == null || self.isStopped() && ((Actor)this.getActor()).isStopped()) {
            return;
        }
        this.getActorRef().__stopped = true;
        ((Actor)this.getActor()).__stopped = true;
        this.getActorRef().__throwExAtBlock = true;
        ((Actor)this.getActor()).__throwExAtBlock = true;
        if (this.__stopHandlers != null) {
            this.__stopHandlers.forEach((Consumer<Callback<SELF>>)((Consumer<Callback>)cb -> cb.complete(this.self(), null)));
            this.__stopHandlers.clear();
        }
        throw InternalActorStoppedException.Instance;
    }

    @CallerSideMethod
    public Object __enqueueCall(Actor receiver, String methodName, Object[] args, boolean isCB) {
        if (this.__stopped) {
            if (methodName.equals("stop")) {
                return null;
            }
            this.__addDeadLetter(receiver, methodName);
        }
        return this.__scheduler.enqueueCall(sender.get(), receiver, methodName, args, isCB);
    }

    @CallerSideMethod
    public void __addDeadLetter(Actor receiver, String methodName) {
        String senderString = sender.get() == null ? "null" : sender.get().getClass().getName();
        String s = "DEAD LETTER: sender:" + senderString + " receiver::msg:" + receiver.getClass().getSimpleName() + "::" + methodName;
        s = s.replace("_ActorProxy", "");
        Actors.AddDeadLetter(s);
    }

    @CallerSideMethod
    public Method __getCachedMethod(String methodName, Actor actor) {
        Method method;
        if (this.methodCache == null) {
            this.methodCache = new ConcurrentHashMap(7);
        }
        if ((method = (Method)this.methodCache.get(methodName)) == null) {
            Method[] methods = actor.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName)) continue;
                this.methodCache.put(methodName, m);
                method = m;
                break;
            }
        }
        return method;
    }

    @Override
    @Local
    public IPromise getReport() {
        return new Promise<ActorReport>(new ActorReport(this.getActor().getClass().getSimpleName(), this.getMailboxSize(), this.getCallbackSize()));
    }

    @Override
    @Local
    public IPromise<Monitorable[]> getSubMonitorables() {
        return new Promise<Monitorable[]>(new Monitorable[0]);
    }

    public static class ActorReport {
        String clz;
        int mailboxSize;
        int cbqSize;

        public ActorReport() {
        }

        public ActorReport(String clz, int mailboxSize, int cbqSize) {
            this.clz = clz;
            this.mailboxSize = mailboxSize;
            this.cbqSize = cbqSize;
        }

        public String getClz() {
            return this.clz;
        }

        public int getMailboxSize() {
            return this.mailboxSize;
        }

        public int getCbqSize() {
            return this.cbqSize;
        }
    }
}

