/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;

public class PromiseLatch<T> {
    IPromise<T> wrapped;
    AtomicInteger count;

    public PromiseLatch(IPromise<T> wrapped) {
        this.wrapped = wrapped;
        this.count = new AtomicInteger(1);
    }

    public PromiseLatch(int counter, IPromise<T> wrapped) {
        this(wrapped, counter);
    }

    public PromiseLatch(int counter) {
        this(new Promise(), counter);
    }

    public PromiseLatch(IPromise<T> wrapped, int counter) {
        this.wrapped = wrapped;
        this.count = new AtomicInteger(counter);
    }

    public void countDown() {
        this.countDown(null, null);
    }

    public void countDown(T result, Object error) {
        int i = this.count.decrementAndGet();
        if (i == 0) {
            this.wrapped.complete(result, error);
        } else if (i < 0) {
            throw new RuntimeException("latch already triggered !");
        }
    }

    public void countUp(int amount) {
        this.count.incrementAndGet();
    }

    public int getCount() {
        return this.count.get();
    }

    public IPromise<T> getPromise() {
        return this.wrapped;
    }
}

