/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.impl;

import java.util.concurrent.locks.LockSupport;

public class BackOffStrategy {
    public static int SLEEP_NANOS = 2000000;
    public static int SPIN_UNTIL_YIELD = 10;
    public static int YIELD_UNTIL_PARK = 10;
    public static int PARK_UNTIL_SLEEP = 1;
    int yieldCount;
    int parkCount;
    int sleepCount;
    int nanosToPark = SLEEP_NANOS;

    public BackOffStrategy() {
        this.setCounters(SPIN_UNTIL_YIELD, YIELD_UNTIL_PARK, PARK_UNTIL_SLEEP);
    }

    public BackOffStrategy(int spinUntilYield, int yieldUntilPark, int parkUntilSleep) {
        this.setCounters(spinUntilYield, yieldUntilPark, parkUntilSleep);
    }

    public void setCounters(int spinUntilYield, int yieldUntilPark, int parkUntilSleep) {
        this.yieldCount = spinUntilYield;
        this.parkCount = spinUntilYield + yieldUntilPark;
        this.sleepCount = spinUntilYield + yieldUntilPark + parkUntilSleep;
    }

    public int getNanosToPark() {
        return this.nanosToPark;
    }

    public BackOffStrategy setNanosToPark(int nanosToPark) {
        this.nanosToPark = nanosToPark;
        return this;
    }

    public void yield(int count) {
        if (count > this.sleepCount || count < 0) {
            LockSupport.parkNanos(this.nanosToPark);
        } else if (count > this.parkCount) {
            LockSupport.parkNanos(1L);
        } else if (count > this.yieldCount) {
            Thread.yield();
        }
    }

    public boolean isSleeping(int yieldCount) {
        return yieldCount > this.sleepCount;
    }

    public boolean isYielding(int count) {
        return count > this.yieldCount;
    }
}

