/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.asyncio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.asyncio.AsyncFileIOEvent;
import org.nustaq.kontraktor.util.ActorExecutorService;
import org.nustaq.serialization.util.FSTUtil;

public class AsyncFile {
    AsynchronousFileChannel fileChannel;
    AsyncFileIOEvent event = null;
    byte[] tmp;
    static FileAttribute[] NO_ATTRIBUTES = new FileAttribute[0];

    public AsyncFile() {
    }

    public InputStream asInputStream() {
        if (this.tmp != null) {
            throw new RuntimeException("can create Input/OutputStream only once");
        }
        this.tmp = new byte[1];
        return new InputStream(){

            @Override
            public void close() throws IOException {
                AsyncFile.this.close();
            }

            @Override
            public int read() throws IOException {
                int read = this.read(AsyncFile.this.tmp, 0, 1);
                if (read < 1) {
                    return -1;
                }
                return AsyncFile.this.tmp[0] + 256 & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (AsyncFile.this.event == null) {
                    AsyncFile.this.event = new AsyncFileIOEvent(0L, 0, ByteBuffer.allocate(len));
                }
                if (AsyncFile.this.event.getBuffer().capacity() < len) {
                    AsyncFile.this.event.buffer = ByteBuffer.allocate(len);
                }
                ByteBuffer buffer = AsyncFile.this.event.buffer;
                AsyncFile.this.event.reset();
                AsyncFile.this.event = AsyncFile.this.read(AsyncFile.this.event.getNextPosition(), len, buffer).await();
                int readlen = AsyncFile.this.event.getRead();
                if (readlen > 0) {
                    buffer.get(b, off, readlen);
                }
                return readlen;
            }
        };
    }

    public OutputStream asOutputStream() {
        if (this.tmp != null) {
            throw new RuntimeException("can create Input/OutputStream only once");
        }
        this.tmp = new byte[1];
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                AsyncFile.this.tmp[0] = (byte)b;
                this.write(AsyncFile.this.tmp, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (AsyncFile.this.event == null) {
                    AsyncFile.this.event = new AsyncFileIOEvent(0L, 0, ByteBuffer.allocate(len));
                }
                if (AsyncFile.this.event.getBuffer().capacity() < len) {
                    AsyncFile.this.event.buffer = ByteBuffer.allocate(len);
                }
                ByteBuffer buffer = AsyncFile.this.event.buffer;
                AsyncFile.this.event.reset();
                buffer.put(b, off, len);
                buffer.flip();
                AsyncFile.this.event = AsyncFile.this.write(AsyncFile.this.event.getNextPosition(), buffer).await();
                if (AsyncFile.this.event.getRead() != len) {
                    throw new RuntimeException("unexpected. Pls report");
                }
            }

            @Override
            public void close() throws IOException {
                AsyncFile.this.close();
            }
        };
    }

    public AsyncFile(String file) throws IOException {
        this.open(Paths.get(file, new String[0]), StandardOpenOption.READ);
    }

    public AsyncFile(String file, OpenOption ... options) throws IOException {
        this.open(Paths.get(file, new String[0]), options);
    }

    public AsyncFile(Path file, OpenOption ... options) throws IOException {
        this.open(file, options);
    }

    public void open(Path file, OpenOption ... options) throws IOException {
        if (this.fileChannel != null) {
            throw new RuntimeException("can only open once");
        }
        Actor sender = Actor.current();
        HashSet set = new HashSet(options.length);
        Collections.addAll(set, options);
        this.fileChannel = AsynchronousFileChannel.open(file, set, new ActorExecutorService(sender), NO_ATTRIBUTES);
    }

    public long length() {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            FSTUtil.rethrow((Throwable)e);
            return -1L;
        }
    }

    public IPromise<AsyncFileIOEvent> readFully() {
        ByteBuffer buf = ByteBuffer.allocate((int)this.length());
        AsyncFileIOEvent ev = new AsyncFileIOEvent(0L, 0, buf);
        do {
            ev = this.read(ev.nextPosition, (int)((long)((int)this.length()) - ev.nextPosition), buf).await();
        } while (buf.limit() != buf.capacity() && ev.getNextPosition() >= 0L);
        return new Promise<AsyncFileIOEvent>(ev);
    }

    public IPromise<AsyncFileIOEvent> read(final long position, int chunkSize, ByteBuffer target) {
        if (this.fileChannel == null) {
            throw new RuntimeException("file not opened");
        }
        Actor sender = Actor.current();
        final Promise<AsyncFileIOEvent> p = new Promise<AsyncFileIOEvent>();
        if (target == null) {
            target = ByteBuffer.allocate(chunkSize);
        }
        final long bufferStartPos = target.position();
        final ByteBuffer finalTarget = target;
        this.fileChannel.read(target, position, target, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                long newPos = position + (long)finalTarget.limit() - bufferStartPos;
                if (result < 0) {
                    newPos = -1L;
                }
                attachment.flip();
                p.resolve(new AsyncFileIOEvent(newPos, result, finalTarget));
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                p.reject(exc);
            }
        });
        return p;
    }

    public IPromise<AsyncFileIOEvent> write(final long filePosition, final ByteBuffer source) {
        if (this.fileChannel == null) {
            throw new RuntimeException("file not opened");
        }
        Actor sender = Actor.current();
        final Promise<AsyncFileIOEvent> p = new Promise<AsyncFileIOEvent>();
        final long bufferStartPos = source.position();
        final ByteBuffer finalTarget = source;
        this.fileChannel.write(source, filePosition, source, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                if (source.remaining() > 0) {
                    AsyncFile.this.fileChannel.write(source, filePosition, source, this);
                } else {
                    long newPos = filePosition + (long)finalTarget.limit() - bufferStartPos;
                    if (result < 0) {
                        newPos = -1L;
                    }
                    attachment.flip();
                    p.resolve(new AsyncFileIOEvent(newPos, result, finalTarget));
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                p.reject(exc);
            }
        });
        return p;
    }

    public void close() {
        try {
            this.fileChannel.close();
            this.fileChannel = null;
        }
        catch (IOException e) {
            FSTUtil.rethrow((Throwable)e);
        }
    }
}

