/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.AwaitException;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.KTimeoutException;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.Timeout;
import org.nustaq.kontraktor.impl.DispatcherThread;
import org.nustaq.serialization.util.FSTUtil;

public class Promise<T>
implements IPromise<T> {
    protected Object result = null;
    protected Object error;
    protected Callback resultReceiver;
    protected volatile boolean hadResult;
    protected boolean hasFired;
    final AtomicBoolean lock = new AtomicBoolean(false);
    String id;
    IPromise nextFuture;

    public Promise(T result, Object error) {
        this.result = result;
        this.error = error;
        this.hadResult = true;
    }

    public Promise(T result) {
        this(result, null);
    }

    public Promise() {
    }

    public String getId() {
        return this.id;
    }

    public Promise<T> setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public IPromise<T> then(Runnable result) {
        return this.then((r, e) -> result.run());
    }

    @Override
    public IPromise<T> onResult(Consumer<T> resultHandler) {
        return this.then((r, e) -> {
            if (e == null) {
                resultHandler.accept(r);
            }
        });
    }

    @Override
    public IPromise<T> onError(Consumer errorHandler) {
        return this.then((r, e) -> {
            if (e != null && e != Timeout.INSTANCE) {
                errorHandler.accept(e);
            }
        });
    }

    @Override
    public IPromise<T> onTimeout(Consumer timeoutHandler) {
        return this.then((r, e) -> {
            if (e == Timeout.INSTANCE) {
                timeoutHandler.accept(e);
            }
        });
    }

    @Override
    public <OUT> IPromise<OUT> thenAnd(final Function<T, IPromise<OUT>> function) {
        final Promise<T> res = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void complete(T result, Object error) {
                if (Actor.isError(error)) {
                    res.complete((Object)null, error);
                } else {
                    ((IPromise)function.apply(result)).then(res);
                }
            }
        });
        return res;
    }

    @Override
    public <OUT> IPromise<OUT> then(final Consumer<T> function) {
        final Promise<T> res = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void complete(T result, Object error) {
                if (Actor.isError(error)) {
                    res.complete((Object)null, error);
                } else {
                    function.accept(result);
                    res.resolve();
                }
            }
        });
        return res;
    }

    @Override
    public IPromise<T> thenAnd(final Supplier<IPromise<T>> callable) {
        final Promise<T> res = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void complete(T result, Object error) {
                if (Actor.isError(error)) {
                    res.complete((Object)null, error);
                } else {
                    Object call = null;
                    IPromise iPromise = ((IPromise)callable.get()).then(res);
                }
            }
        });
        return res;
    }

    @Override
    public <OUT> IPromise<OUT> catchError(final Function<Object, IPromise<OUT>> function) {
        final Promise<T> res = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void complete(T result, Object error) {
                if (!Actor.isError(error)) {
                    res.complete((Object)null, error);
                } else {
                    ((IPromise)function.apply(error)).then(res);
                }
            }
        });
        return res;
    }

    @Override
    public <OUT> IPromise<OUT> catchError(final Consumer<Object> function) {
        final Promise<T> res = new Promise<T>();
        this.then(new Callback<T>(){

            @Override
            public void complete(T result, Object error) {
                if (!Actor.isError(error)) {
                    res.complete((Object)null, error);
                } else {
                    function.accept(error);
                    res.resolve();
                }
            }
        });
        return res;
    }

    public void timedOut(Timeout to) {
        if (!this.hadResult) {
            this.complete((Object)null, (Object)to);
        }
    }

    @Override
    public IPromise then(Callback resultCB) {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.resultReceiver != null) {
                throw new RuntimeException("Double register of promise listener");
            }
            this.resultReceiver = resultCB;
            if (this.hadResult) {
                this.hasFired = true;
                if (this.nextFuture == null) {
                    this.nextFuture = new Promise<Object>(this.result, this.error);
                    this.lock.set(false);
                    resultCB.complete(this.result, this.error);
                } else {
                    this.lock.set(false);
                    resultCB.complete(this.result, this.error);
                    this.nextFuture.complete(this.result, this.error);
                    IPromise iPromise = this.nextFuture;
                    return iPromise;
                }
            }
            if (resultCB instanceof IPromise) {
                IPromise iPromise = (IPromise)resultCB;
                return iPromise;
            }
            this.lock.set(false);
            while (!this.lock.compareAndSet(false, true)) {
            }
            if (this.nextFuture == null) {
                Promise<T> promise = this.nextFuture = new Promise<T>();
                return promise;
            }
            IPromise iPromise = this.nextFuture;
            return iPromise;
        }
        finally {
            this.lock.set(false);
        }
    }

    public Promise getNext() {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.nextFuture == null) {
                Promise<T> promise = new Promise<T>();
                return promise;
            }
            Promise promise = (Promise)this.nextFuture;
            return promise;
        }
        finally {
            this.lock.set(false);
        }
    }

    public Promise getLast() {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.nextFuture == null) {
                Promise promise = this;
                return promise;
            }
            Promise promise = ((Promise)this.nextFuture).getLast();
            return promise;
        }
        finally {
            this.lock.set(false);
        }
    }

    public void finallyDo(Callback resultCB) {
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.resultReceiver != null) {
                throw new RuntimeException("Double register of future listener");
            }
            this.resultReceiver = resultCB;
            if (this.hadResult) {
                this.hasFired = true;
                this.lock.set(false);
                resultCB.complete(this.result, this.error);
            }
        }
        finally {
            this.lock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void complete(Object res, Object error) {
        this.result = res;
        Object prevErr = this.error;
        this.error = error;
        while (!this.lock.compareAndSet(false, true)) {
        }
        try {
            if (this.hadResult) {
                if (prevErr instanceof Timeout) {
                    this.error = prevErr;
                    this.lock.set(false);
                    return;
                }
                this.lock.set(false);
                throw new RuntimeException("Double result received on future prevErr:" + prevErr + " (res,err) " + res + "," + error);
            }
            this.hadResult = true;
            if (this.resultReceiver != null) {
                if (this.hasFired) {
                    this.lock.set(false);
                    throw new RuntimeException("Double fire on callback");
                }
                this.hasFired = true;
                this.lock.set(false);
                this.resultReceiver.complete(this.result, error);
                this.resultReceiver = null;
                while (!this.lock.compareAndSet(false, true)) {
                }
                if (this.nextFuture != null) {
                    this.lock.set(false);
                    this.nextFuture.complete(this.result, error);
                }
                return;
            }
        }
        finally {
            this.lock.set(false);
        }
    }

    @Override
    public T get() {
        return (T)this.result;
    }

    @Override
    public T await(long timeoutMillis) {
        this.awaitPromise(timeoutMillis);
        return this.awaitHelper();
    }

    @Override
    public IPromise<T> awaitPromise(long timeout) {
        long endtime = 0L;
        if (timeout > 0L) {
            endtime = System.currentTimeMillis() + timeout;
        }
        if (Thread.currentThread() instanceof DispatcherThread) {
            DispatcherThread dt = (DispatcherThread)Thread.currentThread();
            Scheduler scheduler = dt.getScheduler();
            int idleCount = 0;
            dt.__stack.add(this);
            while (!this.isSettled()) {
                if (!dt.pollQs()) {
                    scheduler.pollDelay(++idleCount);
                } else {
                    idleCount = 0;
                }
                if (endtime == 0L || System.currentTimeMillis() <= endtime || this.isSettled()) continue;
                this.timedOut(Timeout.INSTANCE);
                break;
            }
            dt.__stack.remove(dt.__stack.size() - 1);
            return this;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.then((res, err) -> latch.countDown());
        boolean timedOut = false;
        try {
            timedOut = !latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (timedOut) {
            this.timedOut(Timeout.INSTANCE);
        }
        return this;
    }

    private T awaitHelper() {
        if (Actor.isError(this.getError())) {
            if (this.getError() instanceof Throwable) {
                FSTUtil.rethrow((Throwable)((Throwable)this.getError()));
                return null;
            }
            if (this.getError() == Timeout.INSTANCE) {
                throw new KTimeoutException();
            }
            throw new AwaitException(this.getError());
        }
        return this.get();
    }

    @Override
    public IPromise timeoutIn(long millis) {
        Actor actor = Actor.sender.get();
        if (actor != null) {
            actor.delayed(millis, () -> this.timedOut(Timeout.INSTANCE));
        } else {
            Actors.delayedCalls.schedule(new TimerTask(){

                @Override
                public void run() {
                    Promise.this.timedOut(Timeout.INSTANCE);
                }
            }, millis);
        }
        return this;
    }

    @Override
    public Object getError() {
        return this.error;
    }

    @Override
    public boolean isSettled() {
        return this.hadResult;
    }

    public boolean _isHadResult() {
        return this.hadResult;
    }

    public boolean _isHasFired() {
        return this.hasFired;
    }

    public String toString() {
        return "Result{result=" + this.result + ", error=" + this.error + '}';
    }
}

