/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.impl.RemoteScheduler;
import org.nustaq.kontraktor.remoting.base.ActorClientConnector;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.base.RemoteRefPolling;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.serialization.util.FSTUtil;

public class ActorClient<T extends Actor> {
    protected ActorClientConnector client;
    protected Class<T> facadeClass;
    protected Coding coding;
    protected ThreadLocal<RemoteRefPolling> poller = new ThreadLocal<RemoteRefPolling>(){

        @Override
        protected RemoteRefPolling initialValue() {
            return new RemoteRefPolling();
        }
    };

    public ActorClient(ActorClientConnector client, Class<T> facadeClass, Coding coding) {
        this.facadeClass = facadeClass;
        this.client = client;
        this.coding = coding;
        if (this.coding == null) {
            this.coding = new Coding(SerializerType.FSTSer);
        }
    }

    public IPromise<T> connect() {
        return this.connect(RemoteScheduler.DEFQSIZE, null);
    }

    public IPromise<T> connect(int qsiz) {
        return this.connect(qsiz, null);
    }

    public IPromise<T> connect(int qsiz, Consumer<Actor> discon) {
        Promise result = new Promise();
        try {
            this.client.connect(writesocket -> {
                T facadeProxy = Actors.AsActor(this.facadeClass, new RemoteScheduler(qsiz));
                ((Actor)facadeProxy).__remoteId = 1L;
                final AtomicReference<ObjectSocket> socketRef = new AtomicReference<ObjectSocket>((ObjectSocket)writesocket);
                final ConnectionRegistry reg = new ConnectionRegistry(this.coding, (Actor)facadeProxy, socketRef){
                    final /* synthetic */ Actor val$facadeProxy;
                    final /* synthetic */ AtomicReference val$socketRef;
                    {
                        this.val$facadeProxy = actor;
                        this.val$socketRef = atomicReference;
                        super(code);
                    }

                    @Override
                    public Actor getFacadeProxy() {
                        return this.val$facadeProxy;
                    }

                    @Override
                    public AtomicReference<ObjectSocket> getWriteObjectSocket() {
                        return this.val$socketRef;
                    }
                };
                reg.setDisconnectHandler(discon);
                if (this.coding.getCrossPlatformShortClazzNames() != null) {
                    reg.getConf().registerCrossPlatformClassMappingUseSimpleName(this.coding.getCrossPlatformShortClazzNames());
                }
                writesocket.setConf(reg.getConf());
                Actor.current();
                ObjectSink objectSink = new ObjectSink(){

                    @Override
                    public void receiveObject(ObjectSink sink, Object received, List<IPromise> createdFutures, Object securityContext) {
                        try {
                            reg.receiveObject((ObjectSocket)socketRef.get(), sink, received, createdFutures, securityContext);
                        }
                        catch (Exception e) {
                            FSTUtil.rethrow((Throwable)e);
                        }
                    }

                    @Override
                    public void sinkClosed() {
                        reg.disconnect();
                    }
                };
                reg.registerRemoteRefDirect((Actor)facadeProxy);
                this.poller.get().scheduleSendLoop(reg).then(() -> objectSink.sinkClosed());
                result.resolve(facadeProxy);
                return objectSink;
            });
        }
        catch (Exception e) {
            if (!result.isSettled()) {
                result.reject(e);
            }
            e.printStackTrace();
        }
        return result;
    }
}

