/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.Spore;
import org.nustaq.kontraktor.Timeout;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.annotations.Remoted;
import org.nustaq.kontraktor.annotations.Secured;
import org.nustaq.kontraktor.impl.ActorProxyFactory;
import org.nustaq.kontraktor.impl.CallEntry;
import org.nustaq.kontraktor.impl.CallbackWrapper;
import org.nustaq.kontraktor.impl.InternalActorStoppedException;
import org.nustaq.kontraktor.impl.RemoteScheduler;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.base.Reconnect;
import org.nustaq.kontraktor.remoting.base.RemotedActor;
import org.nustaq.kontraktor.remoting.base.SessionResurrector;
import org.nustaq.kontraktor.remoting.base.UnknownActorException;
import org.nustaq.kontraktor.remoting.encoding.ActorRefSerializer;
import org.nustaq.kontraktor.remoting.encoding.CallbackRefSerializer;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.RemoteCallEntry;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.encoding.SporeRefSerializer;
import org.nustaq.kontraktor.remoting.encoding.TimeoutSerializer;
import org.nustaq.kontraktor.routers.AbstractKrouter;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;

public abstract class ConnectionRegistry {
    public static final Object OUT_OF_ORDER_SEQ = "OOOS";
    public static int MAX_BATCH_CALLS = 500;
    public static BiFunction remoteCallMapper;
    public AtomicReference<Object> userData = new AtomicReference();
    private ActorServer server;
    private boolean secured;
    protected long lastRoutingClientPing = 0L;
    protected FSTConfiguration conf;
    protected RemoteScheduler scheduler = new RemoteScheduler();
    protected AtomicLong actorIdCount = new AtomicLong(0L);
    protected ConcurrentHashMap<Long, Object> publishedActorMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<Object, Long> publishedActorMappingReverse = new ConcurrentHashMap();
    protected ConcurrentLinkedQueue<Actor> remoteActors = new ConcurrentLinkedQueue();
    protected ConcurrentHashMap<Long, Actor> remoteActorMap = new ConcurrentHashMap();
    protected volatile boolean terminated = false;
    protected BiFunction<Actor, String, Boolean> remoteCallInterceptor = (actor, methodName) -> {
        Method method = actor.__getCachedMethod((String)methodName, (Actor)actor, null);
        if (method == null) {
            Log.Warn(null, "no such method on " + actor.getClass().getSimpleName() + "#" + methodName);
        }
        if (method == null || ActorProxyFactory.getInheritedAnnotation(Local.class, method) != null) {
            return false;
        }
        if (this.secured && ActorProxyFactory.getInheritedAnnotation(Remoted.class, method) == null) {
            Log.Warn(null, "method not @Remoted " + actor.getClass().getSimpleName() + "#" + methodName);
            return false;
        }
        return true;
    };
    protected Consumer<Actor> disconnectHandler;
    protected boolean isObsolete;
    private Actor facadeActor;

    public static void registerDefaultClassMappings(FSTConfiguration conf) {
        conf.registerCrossPlatformClassMapping((String[][])new String[][]{{"call", RemoteCallEntry.class.getName()}, {"cbw", CallbackWrapper.class.getName()}});
    }

    public ConnectionRegistry(FSTConfiguration conf, Coding coding) {
        this.conf = conf;
        this.configureSerialization(coding);
    }

    public ConnectionRegistry(Coding code) {
        if (code == null) {
            code = new Coding(SerializerType.FSTSer);
        }
        this.conf = code.createConf();
        ConnectionRegistry.registerDefaultClassMappings(this.conf);
        this.configureSerialization(code);
    }

    public BiFunction<Actor, String, Boolean> getRemoteCallInterceptor() {
        return this.remoteCallInterceptor;
    }

    protected void configureSerialization(Coding code) {
        this.conf.registerSerializer(Actor.class, (FSTObjectSerializer)new ActorRefSerializer(this), true);
        this.conf.registerSerializer(CallbackWrapper.class, (FSTObjectSerializer)new CallbackRefSerializer(this), true);
        this.conf.registerSerializer(Spore.class, (FSTObjectSerializer)new SporeRefSerializer(), true);
        this.conf.registerSerializer(Timeout.class, (FSTObjectSerializer)new TimeoutSerializer(), false);
        this.conf.registerClass(new Class[]{RemoteCallEntry.class});
        this.conf.registerClass(new Class[]{Spore.class});
        this.conf.registerClass(new Class[]{CallbackWrapper.class});
        this.conf.registerClass(new Class[]{Actor.class});
    }

    public Actor getPublishedActor(long id) {
        return (Actor)this.publishedActorMap.get(id);
    }

    public Callback getPublishedCallback(long id) {
        Object o = this.publishedActorMap.get(id);
        if (o instanceof Callback) {
            return (Callback)o;
        }
        return null;
    }

    public RemoteScheduler getScheduler() {
        return this.scheduler;
    }

    public ConcurrentLinkedQueue<Actor> getRemoteActors() {
        return this.remoteActors;
    }

    public ConcurrentHashMap<Long, Actor> getRemoteActorMap() {
        return this.remoteActorMap;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public long publishActor(Actor act) {
        Long integer = this.publishedActorMappingReverse.get(act.getActorRef());
        if (integer == null) {
            integer = this.newActId();
            this.publishActorDirect(integer, act);
        }
        return integer;
    }

    private long newActId() {
        long id = this.actorIdCount.incrementAndGet();
        return id;
    }

    private void publishActorDirect(Long id, Actor act) {
        Object o = this.publishedActorMap.get(id);
        if (o != null && o != act.getActorRef()) {
            Log.Error((Object)this, "id already present old:" + o + " new:" + act);
        }
        this.publishedActorMap.put(id, act.getActorRef());
        this.publishedActorMappingReverse.put(act.getActorRef(), id);
        act.__addRemoteConnection(this);
    }

    public void unpublishActor(Actor act) {
        Long integer = this.publishedActorMappingReverse.get(act.getActorRef());
        if (integer != null) {
            Log.Debug((Object)this, "" + act.getClass().getSimpleName() + " unpublished");
            this.publishedActorMap.remove(integer);
            this.publishedActorMappingReverse.remove(act.getActorRef());
            act.__removeRemoteConnection(this);
            if (act instanceof RemotedActor) {
                String connectionIdentifier = this.getSocketRef().getConnectionIdentifier();
                ((RemotedActor)((Object)act)).hasBeenUnpublished(connectionIdentifier);
            }
        }
    }

    public long registerPublishedCallback(Callback cb) {
        Long integer = this.publishedActorMappingReverse.get(cb);
        if (integer == null) {
            integer = this.newActId();
            this.publishedActorMap.put(integer, cb);
            this.publishedActorMappingReverse.put(cb, integer);
        }
        return integer;
    }

    public void removePublishedObject(long receiverKey) {
        Object remove = this.publishedActorMap.remove(receiverKey);
        if (remove != null) {
            this.publishedActorMappingReverse.remove(remove);
        } else {
            Log.Warn((Object)this, "MISS REMOVE:" + receiverKey);
        }
    }

    public void registerRemoteRefDirect(Actor act) {
        act = act.getActorRef();
        this.remoteActorMap.put(act.__remoteId, act);
        this.remoteActors.add(act);
        act.__clientConnection = this;
        act.__addStopHandler((actor, err) -> this.remoteRefStopped((Actor)actor));
    }

    public Actor registerRemoteActorRef(Class actorClazz, long remoteId, Object client) {
        Actor actorRef = this.remoteActorMap.get(remoteId);
        if (actorRef == null) {
            Object res = Actors.AsActor(actorClazz, this.getScheduler());
            ((Actor)res).__remoteId = remoteId;
            this.remoteActorMap.put(remoteId, (Actor)res);
            this.remoteActors.add((Actor)res);
            ((Actor)res).__addStopHandler((actor, err) -> this.remoteRefStopped((Actor)actor));
            ((Actor)res).__clientConnection = this;
            return res;
        }
        return actorRef;
    }

    protected void remoteRefStopped(Actor actor) {
        this.removeRemoteActor(actor);
        actor.getActorRef().__stopped = true;
        ((Actor)actor.getActor()).__stopped = true;
    }

    public void stopRemoteRefs() {
        new ArrayList<Actor>(this.remoteActors).forEach(actor -> {
            if (this.disconnectHandler != null) {
                this.disconnectHandler.accept((Actor)actor);
            }
            try {
                this.removeRemoteActor((Actor)actor);
            }
            catch (Exception e) {
                Log.Warn((Object)this, e);
            }
            actor.getActorRef().__stopped = true;
            Object tmp = actor.getActor();
            if (tmp != null) {
                ((Actor)tmp).__stopped = true;
            }
        });
    }

    protected void removeRemoteActor(Actor act) {
        this.remoteActorMap.remove(act.__remoteId);
        this.remoteActors.remove(act);
        try {
            act.__stop();
        }
        catch (InternalActorStoppedException internalActorStoppedException) {
            // empty catch block
        }
    }

    public boolean receiveObject(ObjectSocket responseChannel, ObjectSink receiver, Object response, List<IPromise> createdFutures, Object authContext) throws Exception {
        if (response == OUT_OF_ORDER_SEQ) {
            Log.Warn((Object)this, "out of sequence remote call received");
            return false;
        }
        if (response instanceof Reconnect && this.facadeActor instanceof SessionResurrector) {
            String sid = ((Reconnect)response).getSessionId();
            Actor target = ((SessionResurrector)((Object)this.facadeActor)).reanimate(sid, -1L).await();
            if (target != null) {
                this.publishActorDirect(((Reconnect)response).getRemoteRefId(), target);
            }
            return false;
        }
        if (response instanceof Object[]) {
            Object[] arr = (Object[])response;
            boolean hadResp = false;
            int max = arr.length - 1;
            int inSequence = 0;
            if (!(arr[max] instanceof Number)) {
                ++max;
            } else {
                inSequence = ((Number)arr[max]).intValue();
            }
            for (int i = 0; i < max; ++i) {
                Object resp = arr[i];
                if (!(resp instanceof RemoteCallEntry)) {
                    if (resp != null && !"SP".equals(resp)) {
                        Log.Lg.error(this, null, "unexpected response:" + resp);
                    }
                    hadResp = true;
                    continue;
                }
                try {
                    if (!this.processRemoteCallEntry(responseChannel, (RemoteCallEntry)resp, createdFutures, authContext)) continue;
                    hadResp = true;
                    continue;
                }
                catch (UnknownActorException uae) {
                    Log.Warn((Object)this, "Unknown actor id " + ((RemoteCallEntry)resp).getReceiverKey());
                }
            }
            return hadResp;
        }
        if (!(response instanceof RemoteCallEntry)) {
            if (response != null && !"SP".equals(response)) {
                Log.Lg.error(this, null, "unexpected response:" + response);
            }
            return true;
        }
        try {
            if (this.processRemoteCallEntry(responseChannel, (RemoteCallEntry)response, createdFutures, authContext)) {
                return true;
            }
        }
        catch (UnknownActorException uae) {
            this.inFacadeThread(() -> {
                try {
                    responseChannel.writeObject("Unknown actor id " + ((RemoteCallEntry)response).getReceiverKey());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            return true;
        }
        return false;
    }

    protected boolean processRemoteCallEntry(ObjectSocket objSocket, RemoteCallEntry response, List<IPromise> createdFutures, Object authContext) throws Exception {
        RemoteCallEntry read = response;
        long receiverKey = read.getReceiverKey();
        if (read.getQueue() == 0) {
            if (remoteCallMapper != null) {
                read = (RemoteCallEntry)remoteCallMapper.apply(this, read);
            }
            if (this.facadeActor instanceof AbstractKrouter) {
                this.facadeActor.__dispatchRemoteCall(objSocket, read, this, createdFutures, authContext, this.remoteCallInterceptor);
            } else {
                Actor targetActor = this.getPublishedActor(receiverKey);
                if (receiverKey < 0L && targetActor == null) {
                    targetActor = this.getPublishedActor(-receiverKey);
                }
                if (targetActor == null && this.facadeActor instanceof SessionResurrector) {
                    try {
                        SessionResurrector actorRef = (SessionResurrector)((Object)this.facadeActor.getActorRef());
                        targetActor = actorRef.reanimate(objSocket.getConnectionIdentifier(), receiverKey).await();
                        if (targetActor != null) {
                            this.publishActorDirect(receiverKey, targetActor);
                        }
                    }
                    catch (Throwable th) {
                        Log.Info((Object)this, th);
                    }
                }
                if (receiverKey == 0L) {
                    if (this.getFacadeProxy() != null && this.getFacadeProxy().zzServerMsgCallback != null) {
                        read.unpackArgs(this.conf);
                        this.getFacadeProxy().zzServerMsgCallback.complete(read, null);
                    }
                    return false;
                }
                if (targetActor == null) {
                    Log.Lg.error(this, null, "registry:" + System.identityHashCode(this) + " no actor found for key " + read);
                    throw new UnknownActorException("unknown actor id " + receiverKey);
                }
                targetActor.__dispatchRemoteCall(objSocket, read, this, createdFutures, authContext, this.remoteCallInterceptor);
            }
        } else if (read.getQueue() == 1) {
            Callback publishedCallback;
            if (remoteCallMapper != null) {
                read = (RemoteCallEntry)remoteCallMapper.apply(this, read);
            }
            if ((publishedCallback = this.getPublishedCallback(receiverKey)) == null) {
                publishedCallback = this.getPublishedCallback(-receiverKey);
                if (publishedCallback != null) {
                    publishedCallback.complete(read, null);
                    return false;
                }
                if (read.getArgs() != null && read.getArgs().length == 2 && read.getArgs()[1] instanceof InternalActorStoppedException) {
                    Log.Warn((Object)this, "call to stopped remote actor");
                } else {
                    Log.Warn((Object)this, "Publisher already deregistered, set error to 'Actor.CONT' in order to signal more messages will be sent. " + read);
                }
            } else {
                boolean isContinue = read.isContinue();
                if (publishedCallback instanceof CallbackWrapper && ((CallbackWrapper)publishedCallback).isRouted()) {
                    publishedCallback.complete(read, null);
                } else {
                    read.unpackArgs(this.conf);
                    if (isContinue) {
                        read.getArgs()[1] = "CNT";
                    }
                    publishedCallback.complete(read.getArgs()[0], read.getArgs()[1]);
                }
                if (!isContinue) {
                    this.removePublishedObject(receiverKey);
                }
            }
        }
        return createdFutures != null && createdFutures.size() > 0;
    }

    public void cleanUp() {
        this.conf.clearCaches();
        this.stopRemoteRefs();
        ((ConcurrentHashMap.KeySetView)this.publishedActorMappingReverse.keySet()).forEach(act -> {
            if (act instanceof Actor) {
                this.unpublishActor((Actor)act);
            }
        });
        this.getFacadeProxy().__removeRemoteConnection(this);
    }

    public void disconnect() {
        this.setTerminated(true);
        this.cleanUp();
    }

    protected void closeRef(CallEntry ce, ObjectSocket chan) throws IOException {
        if (ce.getTargetActor().getActorRef() == this.getFacadeProxy().getActorRef()) {
            chan.close();
        } else {
            this.removeRemoteActor(ce.getTargetActor());
        }
    }

    protected void writeObject(ObjectSocket chan, RemoteCallEntry rce) throws Exception {
        try {
            chan.writeObject(rce);
        }
        catch (Exception e) {
            Log.Debug((Object)this, "a connection closed '" + e.getMessage() + "', terminating registry");
            this.disconnect();
        }
    }

    public void inFacadeThread(Runnable toRun) {
        if (this.facadeActor != null) {
            if (Thread.currentThread() != this.facadeActor.getCurrentDispatcher()) {
                this.facadeActor.execute(toRun);
                return;
            }
        } else {
            boolean bl = true;
        }
        toRun.run();
    }

    public void forwardRemoteMessage(RemoteCallEntry rce) {
        try {
            ObjectSocket chan = this.getWriteObjectSocket().get();
            this.writeObject(chan, rce);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receiveCBResult(ObjectSocket chan, long id, Object result, Object error) {
        RemoteCallEntry rce = new RemoteCallEntry(0L, id, null, null, this.conf.asByteArray((Object)new Object[]{result, error}));
        rce.setQueue(1);
        rce.setContinue(error == "CNT");
        try {
            this.writeObject(chan, rce);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close(Actor closedOne) {
        try {
            this.getWriteObjectSocket().get().flush();
            if (closedOne.getActor() == this.facadeActor.getActor()) {
                this.getWriteObjectSocket().get().close();
            }
        }
        catch (Exception e) {
            Log.Warn((Object)this, e);
        }
        this.cleanUp();
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public abstract Actor getFacadeProxy();

    public void setDisconnectHandler(Consumer<Actor> disconnectHandler) {
        this.disconnectHandler = disconnectHandler;
    }

    public Consumer<Actor> getDisconnectHandler() {
        return this.disconnectHandler;
    }

    public void setClassLoader(ClassLoader l) {
        this.conf.setClassLoader(l);
    }

    public long getRemoteId(Actor act) {
        Long integer = this.publishedActorMappingReverse.get(act.getActorRef());
        return integer == null ? -1L : integer;
    }

    public boolean pollAndSend2Remote(AtomicReference<ObjectSocket> chanHolder) throws Exception {
        int sumQueued;
        ObjectSocket chan = chanHolder.get();
        if (chan == null || !chan.canWrite()) {
            return false;
        }
        boolean hadAnyMsg = false;
        ArrayList<Actor> toRemove = null;
        int fullqueued = 0;
        do {
            sumQueued = 0;
            for (Actor remoteActor : this.remoteActors) {
                boolean cb = false;
                CallEntry ce = (CallEntry)remoteActor.__cbQueue.poll();
                if (ce == null) {
                    cb = false;
                    ce = (CallEntry)remoteActor.__mailbox.poll();
                }
                if (ce == null) continue;
                if (ce.getMethod().getName().equals("close")) {
                    this.closeRef(ce, chan);
                    continue;
                }
                if (ce.getMethod().getName().equals("asyncstop")) {
                    Log.Lg.error(this, null, "cannot stop remote actors");
                    continue;
                }
                long futId = 0L;
                if (ce.hasFutureResult()) {
                    futId = this.registerPublishedCallback(ce.getFutureCB());
                }
                try {
                    RemoteCallEntry rce = new RemoteCallEntry(futId, remoteActor.__remoteId, ce.getMethod().getName(), ce.getArgs(), null);
                    rce.setQueue(cb ? 1 : 0);
                    rce.pack(this.conf);
                    this.writeObject(chan, rce);
                    ++sumQueued;
                    hadAnyMsg = true;
                }
                catch (Throwable ex) {
                    if (ex instanceof InvocationTargetException && ((InvocationTargetException)ex).getTargetException() != null) {
                        ex = ((InvocationTargetException)ex).getTargetException();
                    }
                    if (ex instanceof IOError || ex instanceof IOException) {
                        chan.setLastError(ex);
                        if (toRemove == null) {
                            toRemove = new ArrayList<Actor>();
                        }
                        toRemove.add(remoteActor);
                        remoteActor.__stop();
                        Log.Lg.infoLong(this, ex, "connection closed");
                        break;
                    }
                    Log.Error((Object)this, ex);
                    break;
                }
            }
            if (toRemove == null) continue;
            toRemove.forEach(act -> this.removeRemoteActor((Actor)act));
        } while (sumQueued > 0 && (fullqueued += sumQueued) < MAX_BATCH_CALLS);
        chan.flush();
        return hadAnyMsg;
    }

    public abstract AtomicReference<ObjectSocket> getWriteObjectSocket();

    public ObjectSocket getSocketRef() {
        return this.getWriteObjectSocket().get();
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setIsObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public int getRemoteActorSize() {
        return this.remoteActorMap.size();
    }

    public void setFacadeActor(Actor facadeActor) {
        this.facadeActor = facadeActor;
        if (facadeActor.getActor().getClass().getAnnotation(Secured.class) != null) {
            this.secured = true;
        }
    }

    public Actor getFacadeActor() {
        return this.facadeActor;
    }

    public void setServer(ActorServer server) {
        this.server = server;
    }

    public ActorServer getServer() {
        return this.server;
    }

    public IPromise closeNetwork() {
        if (this.server != null) {
            return this.server.close();
        }
        Log.Warn(null, "failed closing underlying network connection as server is null");
        return new Promise<Object>(null, "server is null");
    }

    public void pingFromRoutingClient() {
        this.lastRoutingClientPing = System.currentTimeMillis();
    }

    public long getLastRoutingClientPing() {
        return this.lastRoutingClientPing;
    }

    public long[] getRemotedActorIds() {
        ArrayList res = new ArrayList();
        this.remoteActorMap.forEach((id, actorref) -> {
            if (actorref instanceof Actor) {
                res.add(id);
            }
        });
        long[] lr = new long[res.size()];
        for (int i = 0; i < lr.length; ++i) {
            lr[i] = (Long)res.get(i);
        }
        return lr;
    }

    public long[] getPublishedActorIds() {
        ArrayList res = new ArrayList();
        this.publishedActorMap.forEach((id, actorref) -> {
            if (actorref instanceof Actor) {
                res.add(id);
            }
        });
        long[] lr = new long[res.size()];
        for (int i = 0; i < lr.length; ++i) {
            lr[i] = (Long)res.get(i);
        }
        return lr;
    }

    public String getConnectionIdentifier() {
        ObjectSocket objectSocket = this.getWriteObjectSocket().get();
        if (objectSocket != null) {
            return objectSocket.getConnectionIdentifier();
        }
        return null;
    }
}

