/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nustaq.kontraktor.Callback;

public class KFlow<T> {
    KFlow next;
    Callback<T> cb;

    public KFlow(Callback originalcb) {
        this.cb = originalcb;
    }

    public KFlow() {
        this.cb = (r, e) -> this.consume(r, e);
    }

    public void consume(Object item, Object err) {
        if (this.next != null) {
            this.next.consume(item, err);
        }
    }

    public KFlow<T> each(final Consumer<T> fun) {
        this.next = new KFlow(this.cb){

            @Override
            public void consume(Object item, Object err) {
                if ("CNT".equals(err)) {
                    fun.accept(item);
                }
                super.consume(item, err);
            }
        };
        return this.next;
    }

    public KFlow<T> pairs(final BiConsumer<T, T> fun) {
        this.next = new KFlow(this.cb){
            T prev;

            @Override
            public void consume(Object item, Object err) {
                if ("CNT".equals(err)) {
                    fun.accept(this.prev, item);
                    this.prev = item;
                }
                super.consume(item, err);
            }
        };
        return this.next;
    }

    public KFlow<T> onComplete(final Consumer errfun) {
        this.next = new KFlow(this.cb){

            @Override
            public void consume(Object item, Object err) {
                if (!"CNT".equals(err)) {
                    errfun.accept(err);
                }
                super.consume(item, err);
            }
        };
        return this.next;
    }

    public KFlow<T> filter(final Function<T, Boolean> fun) {
        this.next = new KFlow(this.cb){

            @Override
            public void consume(Object item, Object err) {
                if ("CNT".equals(err)) {
                    Boolean apply = (Boolean)fun.apply(item);
                    if (apply.booleanValue()) {
                        super.consume(item, err);
                    }
                } else {
                    super.consume(item, err);
                }
            }
        };
        return this.next;
    }

    public <K> KFlow<K> map(final Function<T, K> fun) {
        this.next = new KFlow(this.cb){

            @Override
            public void consume(Object item, Object err) {
                if ("CNT".equals(err)) {
                    Object apply = fun.apply(item);
                    super.consume(apply, err);
                } else {
                    super.consume(item, err);
                }
            }
        };
        return this.next;
    }

    public KFlow<Collection<T>> collect(final Collection<T> c) {
        this.next = new KFlow(this.cb){

            @Override
            public void consume(Object item, Object err) {
                if ("CNT".equals(err)) {
                    c.add(item);
                } else {
                    super.consume(c, "CNT");
                    super.consume(null, null);
                }
            }
        };
        return this.next;
    }

    public KFlow<List<T>> list() {
        return this.collect(new ArrayList());
    }

    public Callback cb() {
        return this.cb;
    }

    public Callback callback() {
        return this.cb;
    }

    public static void main(String[] args) {
        String[] arr = new String[]{"a", "b", "c", "d", "e"};
        KFlow<Object> ks = new KFlow<Object>().filter(x -> x.equals("b")).each(x -> System.out.println(x));
        for (int i = 0; i < arr.length; ++i) {
            String s = arr[i];
            ks.cb().pipe(s);
        }
    }
}

