/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.util.Log;

public class RateMeasure {
    AtomicInteger count = new AtomicInteger(0);
    long lastStats;
    int checkEachMask = 7;
    long statInterval = 1000L;
    long lastRatePersecond;
    boolean print = false;
    boolean accumulate = true;
    long accumulated = 0L;
    String name = "none";

    public RateMeasure(String name, long statInterval) {
        this.name = name;
        this.statInterval = statInterval;
    }

    public RateMeasure(String name) {
        this.name = name;
    }

    public long getAccumulated() {
        return this.accumulated;
    }

    public long count() {
        int c = this.count.incrementAndGet();
        if ((c & ~this.checkEachMask) == c) {
            this.checkStats();
        }
        return this.lastRatePersecond;
    }

    public long count(int amount) {
        int c = this.count.addAndGet(amount);
        if ((c & ~this.checkEachMask) == c) {
            this.checkStats();
        }
        return this.lastRatePersecond;
    }

    public int getOpenCount() {
        return this.count.get();
    }

    public RateMeasure print(boolean print) {
        this.print = print;
        return this;
    }

    private void checkStats() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastStats;
        if (diff > this.statInterval) {
            int val = this.count.get();
            this.lastRatePersecond = (long)val * 1000L / diff;
            this.lastStats = now;
            this.accumulated += (long)val;
            this.count.set(0);
            this.statsUpdated(this.lastRatePersecond);
        }
    }

    protected void statsUpdated(long lastRatePersecond) {
        if (this.print) {
            Log.Info((Object)this, "***** Stats for " + this.name + ":   " + lastRatePersecond + "   per second, acc:" + this.accumulated + " *********");
        }
    }

    public RateMeasure lastStats(long lastStats) {
        this.lastStats = lastStats;
        return this;
    }

    public RateMeasure checkEachMask(int checkEachMask) {
        this.checkEachMask = checkEachMask;
        return this;
    }

    public RateMeasure statInterval(long statInterval) {
        this.statInterval = statInterval;
        return this;
    }

    public RateMeasure lastRatePersecond(long lastRatePersecond) {
        this.lastRatePersecond = lastRatePersecond;
        return this;
    }

    public RateMeasure accumulate(boolean accumulate) {
        this.accumulate = accumulate;
        return this;
    }

    public RateMeasure name(String name) {
        this.name = name;
        return this;
    }

    public RateMeasure accumulated(long accumulated) {
        this.accumulated = accumulated;
        return this;
    }
}

