/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.encoding;

import java.io.Serializable;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.serialization.FSTConfiguration;

public class Coding
implements Serializable {
    SerializerType coding;
    Class[] crossPlatformShortClazzNames;

    public Coding(SerializerType coding) {
        this.coding = coding;
    }

    public Coding(SerializerType coding, Class ... crossPlatformShortClazzNames) {
        this.coding = coding;
        this.crossPlatformShortClazzNames = crossPlatformShortClazzNames;
    }

    public Class[] getCrossPlatformShortClazzNames() {
        return this.crossPlatformShortClazzNames;
    }

    public SerializerType getCoding() {
        return this.coding;
    }

    public FSTConfiguration createConf() {
        return switch (this.coding) {
            case SerializerType.MinBin -> FSTConfiguration.createMinBinConfiguration();
            case SerializerType.JsonNoRef -> FSTConfiguration.createJsonConfiguration((boolean)false, (boolean)false);
            case SerializerType.JsonNoRefPretty -> FSTConfiguration.createJsonConfiguration((boolean)true, (boolean)false);
            case SerializerType.UnsafeBinary -> FSTConfiguration.createUnsafeBinaryConfiguration();
            case SerializerType.FSTSer -> FSTConfiguration.createDefaultConfiguration();
            default -> throw new RuntimeException("unknown ser configuration type");
        };
    }

    public String toString() {
        return "Coding{coding=" + this.coding + "}";
    }
}

