/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.routers;

import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorPublisher;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.routers.AbstractKrouter;
import org.nustaq.kontraktor.routers.Krouter;

public class Routing {
    protected static Actor pinger;

    public static <T extends AbstractKrouter> T start(Class<T> krouterClass, ActorPublisher ... publisher) {
        AbstractKrouter res = (AbstractKrouter)Actors.AsActor(krouterClass);
        res.init();
        for (int i = 0; i < publisher.length; ++i) {
            ActorPublisher actorPublisher = publisher[i].facade(res);
            actorPublisher.publish(act -> res.handleServiceDiscon((Actor)act));
        }
        return (T)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Actor getPinger() {
        Class<AbstractKrouter> clazz = AbstractKrouter.class;
        synchronized (AbstractKrouter.class) {
            if (pinger == null) {
                pinger = Actors.AsActor(Actor.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return pinger;
        }
    }

    public static IPromise<Object> connectClient(ConnectableActor connectable, Consumer<Actor> disconnectCallback) {
        Promise<Object> p = Actors.promise();
        connectable.connect(null, disconnectCallback).then((r, e) -> {
            if (r != null) {
                Routing.getPinger().cyclic(AbstractKrouter.CLIENT_PING_INTERVAL_MS, () -> {
                    long[] paids = null;
                    if (r.__clientConnection != null) {
                        paids = r.__clientConnection.getRemotedActorIds();
                    }
                    r.router$clientPing(System.currentTimeMillis(), paids);
                    return true;
                });
            }
            p.complete(r, e);
        });
        return p;
    }

    public static IPromise<Object> registerService(ConnectableActor connectable, Actor service, Consumer<Actor> disconnectCallback, boolean stateful) {
        Promise<Object> p = Actors.promise();
        ((Actor)service.getActor()).zzRoutingGCEnabled = true;
        service.getActorRef().zzRoutingGCEnabled = true;
        if (connectable.getActorClass() == null) {
            connectable.actorClass(Krouter.class);
        }
        service.execute(() -> connectable.connect(null, disconnectCallback).then((r, e) -> {
            if (r != null) {
                try {
                    ((AbstractKrouter)r).router$RegisterService(service.getUntypedRef(), stateful).await();
                }
                catch (Exception ex) {
                    p.complete((Object)null, (Object)ex);
                    return;
                }
            }
            p.complete(r, e);
        }));
        return p;
    }
}

