/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base;

import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.util.Log;

public class ReconnectableRemoteRef<T extends Actor> {
    public static long RETRY_INTERVAL = 1000L;
    public static ReconnectableListener loggingListener = new ReconnectableListener(){

        @Override
        public void remoteDisconnected(Actor disconnected) {
            Log.Info(ReconnectableRemoteRef.class, "remote disconnected " + disconnected);
        }

        @Override
        public void tryConnect(ConnectableActor ca) {
            Log.Info(ReconnectableRemoteRef.class, "try connect " + ca);
        }

        @Override
        public void remoteConnected(Actor connected) {
            Log.Info(ReconnectableRemoteRef.class, "remote connected " + connected);
        }
    };
    Timer timer = new Timer();
    Supplier<ConnectableActor> connectableSup;
    T current;
    ReconnectableListener conListener;
    boolean terminate = false;
    int connectsUnderway = 0;

    public ReconnectableRemoteRef(ConnectableActor remoteActor, ReconnectableListener listener) {
        this(() -> remoteActor, listener);
    }

    public ReconnectableRemoteRef(Supplier<ConnectableActor> remoteActorSup, ReconnectableListener listener) {
        this.connectableSup = remoteActorSup;
        this.conListener = listener;
        this.connectWithRetry();
    }

    IPromise<T> connect() {
        if (this.isOnline()) {
            return new Promise<T>(this.current);
        }
        Promise p = new Promise();
        ConnectableActor connectableActor = this.connectableSup.get();
        if (this.conListener != null) {
            this.conListener.tryConnect(connectableActor);
        }
        connectableActor.connect(null, disc -> {
            this.handleDisconnect();
            if (this.conListener != null) {
                this.conListener.remoteDisconnected((Actor)disc);
            }
        }).then((r, e) -> {
            if (r != null) {
                this.current = r;
                if (this.conListener != null) {
                    this.conListener.remoteConnected((Actor)this.current);
                }
            }
            p.complete(r, e);
        });
        return p;
    }

    protected synchronized void handleDisconnect() {
        if (this.current == null) {
            return;
        }
        Log.Warn((Object)this, "registry disconnected");
        if (this.current != null) {
            ((Actor)this.current).close();
            this.current = null;
        }
        this.connectWithRetry();
    }

    private void connectWithRetry() {
        this.connect().then((r, e) -> {
            if (!this.isOnline() && !this.terminate) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ReconnectableRemoteRef.this.connectWithRetry();
                    }
                }, RETRY_INTERVAL);
            }
        });
    }

    public boolean isOnline() {
        return this.current != null;
    }

    public T get() {
        return this.current;
    }

    public void terminate() {
        this.terminate = true;
    }

    public static interface ReconnectableListener {
        public void remoteDisconnected(Actor var1);

        public void remoteConnected(Actor var1);

        default public void tryConnect(ConnectableActor ca) {
        }
    }
}

