/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.routers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.routers.SingleActiveServiceKrouter;
import org.nustaq.kontraktor.util.Log;

public class HotColdFailoverKrouter<T extends HotColdFailoverKrouter>
extends SingleActiveServiceKrouter<T> {
    List<Actor> remoteServices;

    @Override
    public void init() {
        this.remoteServices = new ArrayList<Actor>();
        super.init();
    }

    @Override
    @Local
    public void router$handleServiceDisconnect(Actor x) {
        boolean remove;
        List newList = this.remoteServices.stream().filter(rs -> rs != x.getActor() && rs != x.getActorRef()).collect(Collectors.toList());
        boolean bl = remove = newList.size() != this.remoteServices.size();
        if (remove) {
            this.remoteServices = newList;
            Log.Info((Object)this, "removed service " + x);
        }
    }

    @Override
    @CallerSideMethod
    protected Actor getRemoteRef() {
        List<Actor> remoteServices = ((HotColdFailoverKrouter)this.getActor()).remoteServices;
        if (remoteServices.size() == 0) {
            return null;
        }
        return remoteServices.get(0);
    }

    @Override
    @CallerSideMethod
    protected void setRemoteRef(Actor remoteRef) {
        ArrayList<Actor> services = new ArrayList<Actor>();
        services.add(remoteRef);
        services.addAll(((HotColdFailoverKrouter)this.getActor()).remoteServices);
        ((HotColdFailoverKrouter)this.getActor()).remoteServices = services;
        Log.Info((Object)this, "service added. #services " + services.size());
    }

    @Override
    protected List<Actor> getServices() {
        return ((HotColdFailoverKrouter)this.getActor()).remoteServices;
    }
}

