/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PerformanceTracker {
    static int siz = (int)(TimeUnit.DAYS.toMillis(1L) / TimeUnit.MINUTES.toMillis(1L));
    static long dayLenMillis = (long)siz * TimeUnit.DAYS.toMillis(1L);
    ConcurrentHashMap<String, Map<String, MethodStats>> entryMap = new ConcurrentHashMap();

    public void registerEntry(String methodName, String targetClass) {
        this.getStats(methodName, targetClass).registerEntry(this.getIndex(System.currentTimeMillis()));
    }

    public void registerExit(String methodName, String targetClass, long duration) {
        this.getStats(methodName, targetClass).registerExit(this.getIndex(System.currentTimeMillis()), duration);
    }

    public void registerException(String methodName, String targetClass) {
    }

    public void registerResult(String methodName, String targetClass, boolean resolveElseReject) {
    }

    MethodStats getStats(String methodName, String targetClass) {
        MethodStats methodStats;
        Map<String, MethodStats> stringMethodStatsMap = this.entryMap.get(targetClass);
        if (stringMethodStatsMap == null) {
            stringMethodStatsMap = new ConcurrentHashMap<String, MethodStats>();
            this.entryMap.put(targetClass, stringMethodStatsMap);
        }
        if ((methodStats = stringMethodStatsMap.get(methodName)) == null) {
            methodStats = new MethodStats(methodName, targetClass);
            stringMethodStatsMap.put(methodName, methodStats);
        }
        return methodStats;
    }

    int getIndex(long currenttim) {
        long timeOfDay = currenttim % dayLenMillis;
        int minuteOfDay = (int)(timeOfDay / TimeUnit.MINUTES.toMillis(1L));
        return minuteOfDay % siz;
    }

    public static void main(String[] args) throws InterruptedException {
        PerformanceTracker pt = new PerformanceTracker();
        System.out.println("size:" + siz);
        while (true) {
            System.out.println(pt.getIndex(System.currentTimeMillis()));
            Thread.sleep(10000L);
        }
    }

    static class MethodStats {
        String method;
        String clazz;
        int[] callCount;
        int[] duration;
        int[] exception;
        int[] resolves;

        public MethodStats(String method, String clazz) {
            this.method = method;
            this.clazz = clazz;
            this.callCount = new int[siz];
            this.duration = new int[siz];
            this.exception = new int[siz];
            this.resolves = new int[siz];
        }

        public void registerEntry(int index) {
            int n = index;
            this.callCount[n] = this.callCount[n] + 1;
        }

        public void registerExit(int index, long dur) {
            int n = index;
            this.duration[n] = this.duration[n] + (int)dur;
        }
    }
}

