/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting;

import java.util.HashMap;
import java.util.Map;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;

public class KConnectionPool {
    Map<String, Actor> connections = new HashMap<String, Actor>();
    Map<String, IPromise> underway = new HashMap<String, IPromise>();

    public IPromise getConnection(ConnectableActor con) {
        String key = con.getKey();
        Actor actor = this.connections.get(key);
        if (actor != null && !actor.isStopped()) {
            return new Promise<Actor>(actor);
        }
        Promise res = new Promise();
        if (this.underway.containsKey(key)) {
            Promise nextpromise = (Promise)this.underway.get(key);
            IPromise then = nextpromise.getLast().then((Callback)res);
            return res;
        }
        this.underway.put(key, new Promise());
        con.connect((cn, e) -> {}, act -> this.connections.remove(key)).then((remote, err) -> {
            IPromise nextpromise;
            if (remote != null) {
                this.connections.put(key, (Actor)remote);
            }
            if ((nextpromise = this.underway.get(key)) != null) {
                nextpromise.complete(remote, err);
            }
            this.underway.remove(key);
            res.complete(remote, err);
        });
        return res;
    }

    public void closeAll() {
        Map<String, Actor> oldMap = this.connections;
        this.connections = new HashMap<String, Actor>();
        oldMap.values().forEach(actor -> actor.unpublish());
    }
}

