/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.base.messagestore;

import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.kontraktor.remoting.base.messagestore.MessageStore;

public class HeapMessageStore
implements MessageStore {
    int maxStoreLength = 64;
    ConcurrentHashMap<CharSequence, StoreEntry> map = new ConcurrentHashMap();

    public HeapMessageStore(int maxStoreLength) {
        this.maxStoreLength = maxStoreLength;
    }

    @Override
    public Object getMessage(CharSequence queueId, long sequence) {
        StoreEntry byteSources = this.map.get(queueId);
        if (byteSources != null) {
            return byteSources.get(sequence);
        }
        return null;
    }

    @Override
    public void putMessage(CharSequence queueId, long sequence, Object message) {
        StoreEntry byteSources = this.map.get(queueId);
        if (byteSources == null) {
            byteSources = new StoreEntry(this.maxStoreLength);
            this.map.put(queueId, byteSources);
        }
        byteSources.add(message, sequence);
    }

    @Override
    public void confirmMessage(CharSequence queueId, long sequence) {
        StoreEntry byteSources = this.map.get(queueId);
        if (byteSources != null) {
            byteSources.confirm(sequence);
        }
    }

    @Override
    public void killQueue(CharSequence queueId) {
        this.map.remove(queueId);
    }

    static class StoreEntry {
        Object[] messages;
        long[] sequences;
        int writePos;
        int readPos;

        public StoreEntry(int len) {
            this.messages = new Object[len];
            this.sequences = new long[len];
        }

        public void add(Object msg, long seq) {
            this.messages[this.writePos] = msg;
            this.sequences[this.writePos] = seq;
            ++this.writePos;
            if (this.writePos == this.messages.length) {
                this.writePos = 0;
            }
            if (this.writePos == this.readPos) {
                ++this.readPos;
                if (this.readPos == this.messages.length) {
                    this.readPos = 0;
                }
            }
        }

        public void confirm(long seq) {
            int idx = this.readPos;
            for (int i = 0; i < this.messages.length; ++i) {
                if (seq > this.sequences[idx]) {
                    this.readPos = idx;
                    if (this.readPos < 0) {
                        this.readPos = 0;
                    }
                    return;
                }
                this.messages[idx] = null;
                this.sequences[idx] = 0L;
                if (++idx != this.messages.length) continue;
                idx = 0;
            }
            this.readPos = idx - 1;
            if (this.readPos < 0) {
                this.readPos = 0;
            }
        }

        public Object get(long seq) {
            int idx = this.readPos;
            for (int i = 0; i < this.messages.length; ++i) {
                if (seq == this.sequences[idx]) {
                    return this.messages[idx];
                }
                if (++idx != this.messages.length) continue;
                idx = 0;
            }
            return null;
        }
    }
}

