/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.ActorProxy;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.annotations.CallerSideMethod;

public class Log
extends Actor<Log> {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static Log Lg = Actors.AsActor(Log.class, 100000);
    public LogWrapper defaultLogger;
    LogWrapper logger;
    volatile int severity;

    public Log() {
        this.logger = this.defaultLogger = new LogWrapper(){
            DateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");
            boolean initialized = false;

            @Override
            public void msg(Thread t, int sev, Object source, Throwable ex, String msg) {
                if (!this.initialized) {
                    this.initialized = true;
                    Thread.currentThread().setName("kontraktor async logger");
                }
                if (Log.this.severity <= sev) {
                    if (source == null) {
                        source = "null";
                    } else if (!(source instanceof String)) {
                        source = source instanceof Class ? ((Class)source).getSimpleName() : source.getClass().getSimpleName();
                    }
                    String tname = t == null ? "-" : t.getName();
                    String svString = "I ";
                    switch (sev) {
                        case 2: {
                            svString = "W ";
                            break;
                        }
                        case 0: {
                            svString = "D ";
                            break;
                        }
                        case 3: {
                            svString = "E ";
                        }
                    }
                    System.out.println(svString + this.formatter.format(new Date()) + ";" + tname + ";" + source + "  " + msg);
                    if (ex != null) {
                        System.out.println("EXC:");
                        ex.printStackTrace(System.out);
                    }
                }
            }
        };
        this.severity = 1;
    }

    public static void SetSynchronous() {
        if (Lg instanceof ActorProxy) {
            Log old = Lg;
            Lg = new Log();
            old.stop();
        }
    }

    public static int setLevel(int level) {
        int oldSeverity = Lg.getSeverity();
        Lg.setSeverity(level);
        return oldSeverity;
    }

    public static void Info(Object source, String msg) {
        Lg.info(source, msg);
    }

    public static void Info(Object source, Throwable ex) {
        Lg.infoLong(source, ex, null);
    }

    public static void Debug(String msg) {
        Lg.debug(null, msg);
    }

    public static void Debug(Object source, String msg) {
        Lg.debug(source, msg);
    }

    public static void Debug(Object source, Throwable th) {
        Lg.debugLong(source, th, null);
    }

    public static void Info(Object source, Throwable t, String msg) {
        Lg.infoLong(source, t, msg);
    }

    public static void Warn(Object source, Throwable t, String msg) {
        Lg.warnLong(source, t, msg);
    }

    public static void Warn(Object source, String msg) {
        Lg.warnLong(source, null, msg);
    }

    public static void Warn(Object source, Throwable ex) {
        Lg.warnLong(source, ex, null);
    }

    public static void Error(Object source, String s) {
        Log.Error(source, null, s);
    }

    public static void Error(Object source, Throwable th) {
        Log.Error(source, th, null);
    }

    public static void Error(Object source, Throwable th, String s) {
        Lg.error(source, th, s);
    }

    public void setLogWrapper(LogWrapper delegate) {
        this.logger = delegate;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    protected Log self() {
        if (Lg instanceof ActorProxy) {
            return (Log)super.self();
        }
        return this;
    }

    @CallerSideMethod
    public int getSeverity() {
        return ((Log)this.getActor()).severity;
    }

    @CallerSideMethod
    public void resetToSysout() {
        this.logger = this.defaultLogger;
    }

    @CallerSideMethod
    public void infoLong(Object source, Throwable ex, String msg) {
        this.self().msg(Thread.currentThread(), 1, source, ex, msg);
    }

    @CallerSideMethod
    public void debug(Object source, String msg) {
        this.self().msg(Thread.currentThread(), 0, source, null, msg);
    }

    @CallerSideMethod
    public void debugLong(Object source, Throwable th, String msg) {
        this.self().msg(Thread.currentThread(), 0, source, th, msg);
    }

    @CallerSideMethod
    public void info(Object source, String msg) {
        this.self().msg(Thread.currentThread(), 1, source, null, msg);
    }

    @CallerSideMethod
    public void warnLong(Object source, Throwable ex, String msg) {
        this.self().msg(Thread.currentThread(), 2, source, ex, msg);
    }

    @CallerSideMethod
    public void warn(Object source, String msg) {
        this.self().msg(Thread.currentThread(), 2, source, null, msg);
    }

    @CallerSideMethod
    public void error(Object source, Throwable ex, String msg) {
        this.self().msg(Thread.currentThread(), 3, source, ex, msg);
    }

    public void msg(Thread t, int severity, Object source, Throwable ex, String msg) {
        this.logger.msg(t, severity, source, ex, msg);
    }

    public static interface LogWrapper {
        public void msg(Thread var1, int var2, Object var3, Throwable var4, String var5);
    }
}

