/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.netty2go;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;

public class WebSocketClient {
    URI uri;
    EventLoopGroup group;
    Channel channel;
    private volatile boolean connected = false;

    public void connect(String url) throws Exception {
        int port;
        String scheme;
        this.uri = new URI(url);
        String string = scheme = this.uri.getScheme() == null ? "http" : this.uri.getScheme();
        if (this.uri.getPort() == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else {
                if ("https".equalsIgnoreCase(scheme)) {
                    throw new RuntimeException("ssl currently not supported");
                }
                port = -1;
            }
        } else {
            port = this.uri.getPort();
        }
        if (!"ws".equalsIgnoreCase(scheme)) {
            System.err.println("Only WS is supported.");
            return;
        }
        this.group = new NioEventLoopGroup();
        try {
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handler});
                }
            });
            this.channel = b.connect(this.uri.getHost(), port).sync().channel();
            handler.handshakeFuture().sync();
            this.connected = true;
        }
        catch (Exception e) {
            if (this.group != null) {
                this.close();
            }
            throw e;
        }
    }

    public void sendText(String text) {
        this.channel.write((Object)new TextWebSocketFrame(text));
    }

    public void sendPong() {
        this.channel.write((Object)new PongWebSocketFrame());
    }

    public void sendBinary(byte[] b, int off, int len) {
        this.channel.write((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len)));
    }

    public void flush() {
        this.channel.flush();
    }

    public void onClose(ChannelHandlerContext ctx) {
    }

    public void onTextMessage(ChannelHandlerContext ctx, String text) {
    }

    public void onBinaryMessage(ChannelHandlerContext ctx, byte[] buffer) {
    }

    public void onPing(ChannelHandlerContext ctx) {
        this.sendPong();
    }

    public void onPong(ChannelHandlerContext ctx) {
        System.out.println("pong from server");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        if (this.isConnected()) {
            this.sendClose();
        }
        this.connected = false;
        this.group.shutdownGracefully();
    }

    public void sendClose() {
        this.channel.write((Object)new CloseWebSocketFrame());
    }

    public static void main(String[] a) throws Exception {
        WebSocketClient client = new WebSocketClient();
        client.connect("ws://127.0.0.1:8887/websocket");
    }

    class WebSocketClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WebSocketClientHandshaker handshaker;
        private ChannelPromise handshakeFuture;

        public WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
            this.handshaker = handshaker;
        }

        public ChannelFuture handshakeFuture() {
            return this.handshakeFuture;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.handshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            WebSocketClient.this.onClose(ctx);
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                System.out.println("WebSocket Client connected!");
                this.handshakeFuture.setSuccess();
                return;
            }
            if (!(msg instanceof WebSocketFrame)) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected message " + msg);
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                WebSocketClient.this.onTextMessage(ctx, textFrame.text());
            } else if (frame instanceof BinaryWebSocketFrame) {
                ByteBuf rawMessage = frame.content();
                int size = rawMessage.readableBytes();
                byte[] buffer = new byte[size];
                rawMessage.readBytes(buffer);
                WebSocketClient.this.onBinaryMessage(ctx, buffer);
            } else if (frame instanceof PingWebSocketFrame) {
                WebSocketClient.this.onPing(ctx);
            } else if (frame instanceof PongWebSocketFrame) {
                WebSocketClient.this.onPong(ctx);
            } else if (frame instanceof CloseWebSocketFrame) {
                WebSocketClient.this.onClose(ctx);
                ch.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure(cause);
            }
            ctx.close();
        }
    }
}

