/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.webserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.nustaq.netty2go.NettyWSHttpServer;
import org.nustaq.webserver.ClientSession;

public class WebSocketHttpServer {
    protected final AttributeKey<ClientSession> session = AttributeKey.valueOf((String)"session");
    public static Logger logger = Logger.getLogger(WebSocketHttpServer.class.getName());
    protected File contentRoot;
    private boolean autoFlush = true;

    public WebSocketHttpServer(File contentRoot) {
        this.contentRoot = contentRoot;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void onOpen(ChannelHandlerContext ctx) {
        ctx.attr(this.session).set((Object)this.createNewSession());
        logger.info("onOpen: " + ctx.attr(this.session).get());
    }

    public void onClose(ChannelHandlerContext ctx) {
        logger.info("close session on:" + ctx.attr(this.session).get() + " closed.");
    }

    public void onHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender) {
        logger.info("request on:" + ctx.attr(this.session));
        if (req.getMethod() != HttpMethod.GET) {
            sender.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
        }
        this.serveFile(ctx, req, sender);
    }

    public void onTextMessage(ChannelHandlerContext ctx, String text) {
        logger.info("text on:" + ctx.attr(this.session) + " '" + text + "'");
        this.sendWSTextMessage(ctx, text);
    }

    public void onBinaryMessage(ChannelHandlerContext ctx, byte[] buffer) {
        logger.info("binary on:" + ctx.attr(this.session));
    }

    public void onPong(ChannelHandlerContext ctx) {
        logger.info("pong on:" + ctx.attr(this.session));
    }

    protected ClientSession getSession(ChannelHandlerContext ctx) {
        return (ClientSession)ctx.attr(this.session).get();
    }

    protected ClientSession createNewSession() {
        ClientSession clientSession = new ClientSession(){};
        logger.info("created session " + clientSession);
        return clientSession;
    }

    public void sendWSTextMessage(ChannelHandlerContext ctx, String s) {
        ctx.channel().write((Object)new TextWebSocketFrame(s));
        if (this.autoFlush) {
            ctx.channel().flush();
        }
    }

    public void sendWSBinaryMessage(ChannelHandlerContext ctx, byte[] b, int off, int len) {
        ctx.channel().write((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len)));
        if (this.autoFlush) {
            ctx.channel().flush();
        }
    }

    public void sendWSPingMessage(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush((Object)new PingWebSocketFrame());
    }

    public void sendWSBinaryMessage(ChannelHandlerContext ctx, byte[] b) {
        this.sendWSBinaryMessage(ctx, b, 0, b.length);
    }

    public void sendHttpGetResponse(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender, String response) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.US_ASCII);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        res.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
        sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveFile(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender) {
        File target;
        String resource = req.getUri().toString();
        if (resource == null || resource.trim().length() == 0 || resource.trim().equals("/")) {
            resource = "/index.html";
        }
        if ((target = new File(this.contentRoot, File.separator + resource)).exists() && target.isFile()) {
            AbstractInterruptibleChannel inChannel = null;
            RandomAccessFile aFile = null;
            try {
                aFile = new RandomAccessFile(target, "r");
                inChannel = aFile.getChannel();
                long fileSize = ((FileChannel)inChannel).size();
                ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                while (((FileChannel)inChannel).read(buffer) > 0) {
                }
                buffer.flip();
                ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)buffer);
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                String accept = req.headers().get("Accept");
                if (accept.indexOf("text/html") >= 0) {
                    res.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
                } else {
                    String[] split = accept.split(";");
                    boolean exit = false;
                    for (int i = 0; i < split.length; ++i) {
                        String s = split[i];
                        String[] ss = s.split(",");
                        for (int j = 0; j < ss.length; ++j) {
                            String s1 = ss[j];
                            if (s1.indexOf(42) >= 0) continue;
                            res.headers().set("Content-Type", (Object)(s1 + "; charset=UTF-8"));
                            exit = true;
                            break;
                        }
                        if (exit) break;
                    }
                }
                HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
                sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (aFile != null) {
                        aFile.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        } else {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        }
    }

    public void removeSession(ChannelHandlerContext ctx) {
        ctx.attr(this.session).remove();
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8887;
        new NettyWSHttpServer(port, new WebSocketHttpServer(new File("."))).run();
    }
}

