/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import de.sayayi.gradle.mql4.task.CompileMQL4Extension;
import de.sayayi.gradle.mql4.task.Mql4Dependency;
import groovy.util.FileNameFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;

public class CompileMQL4Task
extends DefaultTask {
    private CompileMQL4Extension extension;

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @OutputDirectory
    public File getMql4Dir() {
        return this.extension.getMql4Dir();
    }

    @Input
    public String getMetaeditor() {
        return this.extension.getMetaeditor();
    }

    @SkipWhenEmpty
    @InputFiles
    public FileCollection getMql4Files() {
        return this.getProject().files(new Object[]{this.getFiles().values().stream().flatMap(Mql4Dependency::streamDependenciesWithSelf).collect(Collectors.toSet())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public void compileMQL4(IncrementalTaskInputs inputs) throws IOException {
        LogLevel level;
        if (!this.extension.getMql4Dir().isDirectory()) {
            throw new GradleException(this.extension.getMql4Dir().getAbsolutePath() + " is not a directory");
        }
        Logger logger = this.getLogger();
        LogLevel logLevel = level = this.extension.isVerbose() ? LogLevel.QUIET : LogLevel.DEBUG;
        if (!inputs.isIncremental()) {
            this.extension.setForceRecompile(true);
        }
        Map<String, Mql4Dependency> mql4Files = this.getFiles();
        logger.debug("selected mql4 files: {}", mql4Files);
        inputs.outOfDate(change -> {
            mql4Files.values().forEach(dep -> dep.markDirty(change.getFile()));
            this.replaceExtension(change.getFile(), "ex4").delete();
        });
        inputs.removed(change -> this.replaceExtension(change.getFile(), "ex4").delete());
        String mql4DirPath = this.extension.getMql4Dir().getAbsolutePath();
        File tmpBatch = null;
        if (this.extension.isWine()) {
            logger.log(level, "prepare for wine environment");
            tmpBatch = File.createTempFile("mql4c-", ".cmd", this.extension.getMql4Dir());
            tmpBatch.deleteOnExit();
            logger.debug("created temporary batch file {}", (Object)tmpBatch);
        }
        try {
            for (Map.Entry<String, Mql4Dependency> mql4FileEntry : mql4Files.entrySet()) {
                if (this.extension.isForceRecompile() || mql4FileEntry.getValue().isDirty()) {
                    logger.log(level, "compile {} (dependencies {})", new Object[]{mql4FileEntry.getKey(), mql4FileEntry.getValue().getDependencies().stream().map(f -> this.makeRelative(mql4DirPath, f.getAbsolutePath())).collect(Collectors.toList())});
                    this.compileFile(mql4FileEntry, tmpBatch);
                    continue;
                }
                logger.log(level, "{} is up-to-date", new Object[]{this.replaceExtension(mql4FileEntry.getKey(), "ex4")});
            }
            if (tmpBatch == null) return;
        }
        catch (Throwable throwable) {
            if (tmpBatch == null) throw throwable;
            logger.debug("remove temporary batch file {}", tmpBatch);
            Files.delete(tmpBatch.toPath());
            throw throwable;
        }
        logger.debug("remove temporary batch file {}", (Object)tmpBatch);
        Files.delete(tmpBatch.toPath());
    }

    private Map<String, Mql4Dependency> getFiles() {
        FileNameFinder finder = new FileNameFinder();
        LinkedHashMap<String, Mql4Dependency> fileSet = new LinkedHashMap<String, Mql4Dependency>();
        File mql4Dir = this.extension.getMql4Dir();
        String mql4Path = mql4Dir.getAbsolutePath();
        if (!this.extension.getIncludes().isEmpty()) {
            this.extension.getIncludes().forEach(pattern -> finder.getFileNames(mql4Path, pattern).forEach(f -> fileSet.put(this.makeRelative(mql4Path, (String)f), Mql4Dependency.from(mql4Dir, new File((String)f)))));
            this.extension.getExcludes().forEach(pattern -> finder.getFileNames(mql4Path, pattern).forEach(f -> {
                Mql4Dependency cfr_ignored_0 = (Mql4Dependency)fileSet.remove(this.makeRelative(mql4Path, (String)f));
            }));
        }
        return fileSet;
    }

    protected String makeRelative(String base, String f) {
        int baseLength = base.length();
        if (f.length() > baseLength && f.substring(0, baseLength).equals(base) && ((f = f.substring(baseLength)).startsWith("/") || f.startsWith("\\"))) {
            f = f.substring(1);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileFile(Map.Entry<String, Mql4Dependency> mql4FileEntry, File tmpBatch) throws IOException {
        File mq4File = mql4FileEntry.getValue().getParent();
        File ex4File = this.replaceExtension(mq4File, "ex4");
        File logFile = this.replaceExtension(mq4File, "log");
        ExecAction execAction = this.getExecActionFactory().newExecAction();
        if (this.extension.isWine()) {
            this.createBatchfile(mql4FileEntry.getKey(), tmpBatch);
            execAction.setExecutable("wine");
            execAction.setArgs(Arrays.asList("cmd", "/c", tmpBatch));
        } else {
            execAction.setExecutable(this.extension.getMetaeditor());
            execAction.setArgs(Arrays.asList("/compile:\"" + mql4FileEntry.getKey() + "\"", "/inc:\"" + this.extension.getMql4Dir() + "\"", "/log"));
        }
        execAction.setWorkingDir(this.extension.getMql4Dir());
        execAction.setIgnoreExitValue(true);
        ExecResult result = execAction.execute();
        try {
            if (!this.extension.isWine() && result.getExitValue() != 1 || !ex4File.exists() || ex4File.lastModified() < mq4File.lastModified()) {
                if (logFile.exists()) {
                    this.getLogger().error("{}", (Object)this.readLogfile(logFile));
                }
                throw new ExecException("failed to compile " + mql4FileEntry.getKey());
            }
            if (logFile.exists()) {
                this.getLogger().log(this.extension.isVerbose() ? LogLevel.QUIET : LogLevel.DEBUG, "{}", new Object[]{this.readLogfile(logFile)});
            }
        }
        finally {
            logFile.delete();
        }
    }

    protected void createBatchfile(String relativeMq4Path, File batchFile) throws IOException {
        try (FileWriter bos = new FileWriter(batchFile);){
            ((Writer)bos).append("@ECHO OFF\r\n").append('\"').append(this.extension.getMetaeditor()).append("\" ").append("/compile:\"").append(relativeMq4Path.replace("/", "\\")).append("\" ").append("/log").append("\r\n");
        }
    }

    protected String readLogfile(File logFile) {
        StringBuilder text = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), StandardCharsets.UTF_16LE));){
            String line;
            boolean start = true;
            while ((line = reader.readLine()) != null) {
                if (start) {
                    if (line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    if (line.trim().length() == 0) continue;
                }
                text.append("|  ").append(line).append('\n');
                start = false;
            }
        }
        catch (Exception ex) {
            this.getLogger().error("failed to read log file {}", (Object)logFile.getAbsolutePath(), (Object)ex);
        }
        return text.toString();
    }

    protected String replaceExtension(String filename, String ext) {
        int dotIdx = filename.lastIndexOf(46);
        return dotIdx < 0 ? filename + '.' + ext : filename.substring(0, dotIdx + 1) + ext;
    }

    protected File replaceExtension(File f, String ext) {
        return new File(f.getParent(), this.replaceExtension(f.getName(), ext));
    }

    public void setExtension(CompileMQL4Extension extension) {
        this.extension = extension;
    }
}

