/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class Mql4Dependency {
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("\\s*[<\"]([a-zA-Z0-9_/\\x5c\\x2e\\x2d]+)[>\"][\\x00-\\xff]*");
    private static final Logger LOGGER = Logging.getLogger(Mql4Dependency.class);
    private File parent;
    private final Set<Mql4Dependency> dependencies = new HashSet<Mql4Dependency>();
    private boolean dirty;

    private Mql4Dependency(File parent) {
        this.parent = parent;
    }

    public static Mql4Dependency from(File mql4Dir, File mql4File) {
        if (!(mql4File != null && mql4File.exists() && mql4Dir != null && mql4Dir.isDirectory() && mql4File.getAbsolutePath().startsWith(mql4Dir.getAbsolutePath()))) {
            return null;
        }
        Mql4Dependency dependency = new Mql4Dependency(mql4File);
        dependency.parseMql4File(mql4Dir);
        return dependency;
    }

    public boolean isSelf(File file) {
        return this.parent.equals(file);
    }

    public void markDirty(File file) {
        if (this.isSelf(file)) {
            this.dirty = true;
        } else {
            this.dependencies.forEach(dep -> dep.markDirty(file));
        }
    }

    public boolean isDirty() {
        return this.dirty || this.dependencies.stream().filter(Mql4Dependency::isDirty).findAny().isPresent();
    }

    public Set<File> getDependencies() {
        HashSet<File> deps = new HashSet<File>();
        for (Mql4Dependency dep : this.dependencies) {
            deps.add(dep.parent);
            deps.addAll(dep.getDependencies());
        }
        return deps;
    }

    public Stream<File> streamDependenciesWithSelf() {
        HashSet<File> deps = new HashSet<File>();
        deps.add(this.parent);
        deps.addAll(this.getDependencies());
        return deps.stream();
    }

    private void parseMql4File(File mql4Dir) {
        HashSet<File> collectedIncludes = new HashSet<File>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.parent), "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                int idx = line.indexOf("#include");
                if (idx < 0 || !(matcher = INCLUDE_PATTERN.matcher(line.substring(idx + 8))).matches()) continue;
                File includeFile = new File(new File(mql4Dir, "Include"), matcher.group(1));
                collectedIncludes.add(includeFile);
            }
        }
        catch (Exception ex) {
            LOGGER.error("failed to read file {}", (Object)this.parent.getAbsolutePath(), (Object)ex);
        }
        for (File includeFile : collectedIncludes) {
            if (includeFile.exists()) {
                this.dependencies.add(Mql4Dependency.from(mql4Dir, includeFile));
                continue;
            }
            this.dependencies.add(new Mql4Dependency(includeFile));
        }
    }

    public String toString() {
        return "Mql4Dependency(parent=" + this.getParent() + ", dependencies=" + this.getDependencies() + ", dirty=" + this.isDirty() + ")";
    }

    public File getParent() {
        return this.parent;
    }

    public void setParent(File parent) {
        this.parent = parent;
    }
}

