/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import de.sayayi.gradle.mql4.task.Wine;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class CompileMQL4Extension {
    private static final Pattern DOS_EXECUTABLE = Pattern.compile("^.*\\x2e(exe|bat|cmd)$", 2);
    private final Configuration mql4Configuration;
    private final List<String> includes = new ArrayList<String>(Arrays.asList("Indicators/*.mq4", "Experts/*.mq4", "Scripts/*.mq4"));
    private final List<String> excludes = new ArrayList<String>(Arrays.asList("**/*.mqh"));
    private final Wine wine;
    private String metaeditor;
    private File mql4Dir = new File("MQL4");
    private boolean verbose;

    public CompileMQL4Extension(Project project, Configuration mql4Configuration) {
        this.wine = new Wine(project);
        this.mql4Configuration = mql4Configuration;
        this.setMetaeditor(System.getProperty("mql4.metaeditor"));
    }

    public void setMetaeditor(String metaeditor) {
        this.metaeditor = metaeditor != null && DOS_EXECUTABLE.matcher(metaeditor).matches() ? metaeditor : null;
    }

    public void setMql4Dir(String mql4Dir) {
        this.mql4Dir = new File(mql4Dir);
    }

    public void setMql4Dir(File mql4Dir) {
        this.mql4Dir = mql4Dir;
    }

    public void setInclude(String include) {
        this.includes.add(include);
    }

    public void setIncludes(String[] includes) {
        this.includes.clear();
        this.includes.addAll(Arrays.asList(includes));
    }

    public void setIncludes(Collection<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public void setExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void setExcludes(String[] excludes) {
        this.excludes.clear();
        this.excludes.addAll(Arrays.asList(excludes));
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public void wine(Action<? super Wine> action) {
        action.execute((Object)this.wine);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerbose(String verbose) {
        this.verbose = Boolean.parseBoolean(verbose);
    }

    public String toString() {
        return "CompileMQL4Extension(mql4Configuration=" + this.getMql4Configuration() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", wine=" + this.getWine() + ", metaeditor=" + this.getMetaeditor() + ", mql4Dir=" + this.getMql4Dir() + ", verbose=" + this.isVerbose() + ")";
    }

    public Configuration getMql4Configuration() {
        return this.mql4Configuration;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public Wine getWine() {
        return this.wine;
    }

    public String getMetaeditor() {
        return this.metaeditor;
    }

    public File getMql4Dir() {
        return this.mql4Dir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

