/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import de.sayayi.gradle.mql4.task.CompileMQL4Extension;
import de.sayayi.gradle.mql4.task.Mql4Dependency;
import de.sayayi.gradle.mql4.task.Wine;
import groovy.util.FileNameFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;

public class CompileMQL4Task
extends DefaultTask {
    private CompileMQL4Extension extension;

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public String getMetaeditor() {
        return this.extension.getMetaeditor();
    }

    @SkipWhenEmpty
    @InputFiles
    public FileCollection getMq4Files() {
        return this.getProject().files(new Object[]{this.getInputFilesWithDependency().values().stream().flatMap(Mql4Dependency::streamDependenciesWithSelf).collect(Collectors.toSet())});
    }

    @OutputFiles
    public FileCollection getEx4Files() {
        return this.getProject().files(new Object[]{this.getInputFilesWithDependency().values().stream().map(dep -> this.replaceExtension(dep.getFile(), "ex4")).collect(Collectors.toSet())});
    }

    @TaskAction
    public void compileMQL4(IncrementalTaskInputs inputs) throws IOException {
        this.createWinePrefixParentDirectory();
        this.resolveMetaeditor();
        File mql4dir = this.extension.getMql4Dir();
        if (!mql4dir.isDirectory()) {
            throw new GradleException(mql4dir.getAbsolutePath() + " is not a directory");
        }
        Logger logger = this.getLogger();
        Map<String, Mql4Dependency> mql4Files = this.getInputFilesWithDependency();
        logger.debug("selected mql4 files: {}", mql4Files);
        inputs.outOfDate(change -> {
            mql4Files.values().forEach(dep -> dep.markDirty(change.getFile()));
            this.replaceExtension(change.getFile(), "ex4").delete();
        });
        inputs.removed(change -> this.replaceExtension(change.getFile(), "ex4").delete());
        LogLevel level = this.extension.isVerbose() ? LogLevel.QUIET : LogLevel.DEBUG;
        this.compileMQL4(logger, level, mql4Files, mql4dir, inputs.isIncremental());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileMQL4(Logger logger, LogLevel level, Map<String, Mql4Dependency> mql4Files, File mql4dir, boolean incremental) throws IOException {
        String mql4DirPath = mql4dir.getAbsolutePath();
        File tmpBatch = null;
        if (this.extension.getWine().isEnabled()) {
            logger.log(level, "prepare for wine environment");
            tmpBatch = File.createTempFile("mql4c-", ".cmd", mql4dir);
            tmpBatch.deleteOnExit();
            logger.debug("created temporary batch file {}", (Object)tmpBatch);
        }
        try {
            for (Map.Entry<String, Mql4Dependency> mql4FileEntry : mql4Files.entrySet()) {
                if (!incremental || mql4FileEntry.getValue().isDirty()) {
                    logger.log(level, "compile {} (dependencies {})", new Object[]{mql4FileEntry.getKey(), mql4FileEntry.getValue().getDependencies().stream().map(f -> this.makeRelative(mql4DirPath, f.getAbsolutePath())).collect(Collectors.toList())});
                    this.compileFile(mql4FileEntry, tmpBatch);
                    continue;
                }
                logger.log(level, "{} is up-to-date", new Object[]{this.replaceExtension(mql4FileEntry.getKey(), "ex4")});
            }
        }
        finally {
            if (tmpBatch != null) {
                logger.debug("remove temporary batch file {}", (Object)tmpBatch);
                Files.delete(tmpBatch.toPath());
            }
        }
    }

    private Map<String, Mql4Dependency> getInputFilesWithDependency() {
        LinkedHashMap<String, Mql4Dependency> fileSet = new LinkedHashMap<String, Mql4Dependency>();
        if (!this.extension.getIncludes().isEmpty()) {
            TreeSet inputFiles = new TreeSet();
            FileNameFinder finder = new FileNameFinder();
            File mql4Dir = this.extension.getMql4Dir();
            String mql4Path = mql4Dir.getAbsolutePath();
            this.extension.getIncludes().forEach(pattern -> inputFiles.addAll(finder.getFileNames(mql4Path, pattern)));
            this.extension.getExcludes().forEach(pattern -> inputFiles.removeAll(finder.getFileNames(mql4Path, pattern)));
            inputFiles.forEach(f -> fileSet.put(this.makeRelative(mql4Path, (String)f), Mql4Dependency.from(mql4Dir, new File((String)f))));
        }
        return fileSet;
    }

    protected String makeRelative(String base, String f) {
        int baseLength = base.length();
        if (f.length() > baseLength && f.substring(0, baseLength).equals(base) && ((f = f.substring(baseLength)).startsWith("/") || f.startsWith("\\"))) {
            f = f.substring(1);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileFile(Map.Entry<String, Mql4Dependency> mql4FileEntry, File tmpBatch) throws IOException {
        ExecAction execAction = this.getExecActionFactory().newExecAction();
        Wine wine = this.extension.getWine();
        if (wine.isEnabled()) {
            this.createBatchfile(mql4FileEntry.getKey(), tmpBatch);
            execAction.setExecutable(wine.getExecutable());
            execAction.setArgs(Arrays.asList("cmd", "/c", tmpBatch.getAbsolutePath()));
            this.configureWineEnvironment(execAction);
        } else {
            execAction.setExecutable(this.extension.getMetaeditor());
            execAction.setArgs(Arrays.asList("/compile:\"" + mql4FileEntry.getKey() + "\"", "/inc:\"" + this.extension.getMql4Dir() + "\"", "/log"));
        }
        execAction.setWorkingDir(this.extension.getMql4Dir());
        execAction.setIgnoreExitValue(true);
        ExecResult result = execAction.execute();
        File mq4File = mql4FileEntry.getValue().getFile();
        File logFile = this.replaceExtension(mq4File, "log");
        try {
            File ex4File = this.replaceExtension(mq4File, "ex4");
            if (!wine.isEnabled() && result.getExitValue() != 1 || !ex4File.exists() || ex4File.lastModified() < mq4File.lastModified()) {
                if (logFile.exists()) {
                    this.getLogger().error("{}", (Object)this.readLogfile(logFile));
                }
                throw new ExecException("failed to compile " + mql4FileEntry.getKey());
            }
            if (logFile.exists()) {
                this.getLogger().log(this.extension.isVerbose() ? LogLevel.QUIET : LogLevel.DEBUG, "{}", new Object[]{this.readLogfile(logFile)});
            }
        }
        finally {
            logFile.delete();
        }
    }

    protected void configureWineEnvironment(ExecAction execAction) {
        Map environment = execAction.getEnvironment();
        environment.put("WINEDEBUG", "-all");
        File winePrefix = this.extension.getWine().getPrefix();
        if (winePrefix != null) {
            environment.put("WINEPREFIX", winePrefix.getAbsolutePath());
            environment.put("WINEARCH", "win32");
        }
    }

    protected void createBatchfile(String relativeMq4Path, File batchFile) throws IOException {
        try (OutputStreamWriter batchWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(batchFile), StandardCharsets.ISO_8859_1);){
            ((Writer)batchWriter).append("@ECHO OFF\r\n").append('\"').append(this.extension.getMetaeditor()).append("\" ").append("/compile:\"").append(relativeMq4Path.replace("/", "\\")).append("\" ").append("/log").append("\r\n");
        }
    }

    protected String readLogfile(File logFile) {
        StringBuilder text = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), StandardCharsets.UTF_16LE));){
            String line;
            boolean start = true;
            while ((line = reader.readLine()) != null) {
                if (start) {
                    if (line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    if (line.trim().length() == 0) continue;
                }
                text.append("|  ").append(line).append('\n');
                start = false;
            }
        }
        catch (Exception ex) {
            this.getLogger().error("failed to read log file {}", (Object)logFile.getAbsolutePath(), (Object)ex);
        }
        return text.toString();
    }

    protected String replaceExtension(String filename, String ext) {
        int dotIdx = filename.lastIndexOf(46);
        return dotIdx < 0 ? filename + '.' + ext : filename.substring(0, dotIdx + 1) + ext;
    }

    protected File replaceExtension(File f, String ext) {
        return new File(f.getParent(), this.replaceExtension(f.getName(), ext));
    }

    protected void createWinePrefixParentDirectory() {
        File wineprefixParent;
        Wine wine = this.extension.getWine();
        if (wine.isEnabled() && !(wineprefixParent = wine.getPrefix().getParentFile()).isDirectory()) {
            wineprefixParent.mkdirs();
        }
    }

    protected void resolveMetaeditor() {
        Project project = this.getProject();
        File buildDir = project.getBuildDir();
        Configuration configuration = this.extension.getMql4Configuration();
        DependencySet configurationDependencies = configuration.getDependencies();
        if (configurationDependencies.isEmpty()) {
            if (this.extension.getMetaeditor() != null) {
                return;
            }
            configurationDependencies.add((Object)project.getDependencies().create((Object)"de.sayayi:metaeditor:5.+@jar"));
        }
        File metaeditorExe = new File(buildDir, "metaeditor.exe");
        this.extension.setMetaeditor(metaeditorExe.getAbsolutePath());
        if (!metaeditorExe.exists()) {
            project.getLogger().debug("extracting metaeditor.exe to {}", (Object)metaeditorExe);
            project.copy(copy -> {
                copy.from(new Object[]{project.zipTree((Object)configuration.getSingleFile())});
                copy.include(new String[]{"metaeditor.exe"});
                copy.into((Object)buildDir);
            });
        }
    }

    public void setExtension(CompileMQL4Extension extension) {
        this.extension = extension;
    }
}

