/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import de.sayayi.gradle.mql4.task.CompileMQL4Extension;
import de.sayayi.gradle.mql4.task.CompileMQL4Task;
import de.sayayi.gradle.mql4.task.Wine;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.os.OperatingSystem;

public class CompileMQL4TaskPlugin
implements Plugin<Project> {
    private static final Logger logger = Logging.getLogger(CompileMQL4TaskPlugin.class);
    static final String MQL4_EXTENSION_NAME = "mql4";
    static final String MQL4_CONFIGURATION_NAME = "mql4-metaeditor";
    static final String COMPILE_MQl4_TASK_NAME = "compileMql4";

    public void apply(Project project) {
        project.getPlugins().apply("base");
        Configuration mql4Configuration = this.createMql4Configuration(project);
        CompileMQL4Extension mql4 = (CompileMQL4Extension)project.getExtensions().create(MQL4_EXTENSION_NAME, CompileMQL4Extension.class, new Object[]{project, mql4Configuration});
        if (!OperatingSystem.current().isWindows()) {
            this.autoConfigureWine(mql4, project);
        }
        TaskContainer tasks = project.getTasks();
        CompileMQL4Task compileMql4Task = this.createCompileMql4Task(tasks, mql4);
        ((Task)tasks.findByName("assemble")).dependsOn(new Object[]{compileMql4Task});
        ((Task)tasks.findByName("clean")).doLast(task -> compileMql4Task.getEx4Files().forEach(File::delete));
    }

    private CompileMQL4Task createCompileMql4Task(TaskContainer tasks, CompileMQL4Extension mql4) {
        return (CompileMQL4Task)tasks.create(COMPILE_MQl4_TASK_NAME, CompileMQL4Task.class, task -> {
            task.setDescription("Compiles MQL4 indicator, expert advisor and script files.");
            task.setGroup("build");
            task.setExtension(mql4);
        });
    }

    private Configuration createMql4Configuration(Project project) {
        RepositoryHandler repositories = project.getRepositories();
        repositories.add((ArtifactRepository)repositories.maven(r -> r.setUrl((Object)"http://maven.sayayi.de/repository/maven-releases/")));
        Configuration mql4Configuration = ((Configuration)project.getConfigurations().create(MQL4_CONFIGURATION_NAME)).setVisible(false).setDescription("Metaeditor library to be used for this project.");
        return mql4Configuration;
    }

    protected void autoConfigureWine(CompileMQL4Extension mql4, Project project) {
        File _home;
        Wine wine = mql4.getWine();
        wine.setEnabled(true);
        wine.setPrefix(new File(project.getBuildDir(), ".wine"));
        File wineprefix = this.getEnvironmentVariableAsFile("WINEPREFIX");
        if (wineprefix == null && (_home = this.getEnvironmentVariableAsFile("HOME")) != null && _home.isDirectory()) {
            wineprefix = new File(_home, ".wine");
        }
        if (wineprefix != null) {
            if (!wineprefix.isDirectory()) {
                wine.setPrefix(wineprefix);
            } else {
                byte[] headSystemReg = new byte[100];
                boolean win32 = true;
                try (FileInputStream systemReg = new FileInputStream(new File(wineprefix, "system.reg"));){
                    logger.debug("detecting windows architecture for wine environment {}...", (Object)wineprefix);
                    systemReg.read(headSystemReg);
                    logger.debug("{}-bit windows architecture found", (Object)((win32 &= !new String(headSystemReg, StandardCharsets.US_ASCII).contains("#arch=win32")) ? "32" : "64"));
                }
                catch (Exception ex) {
                    logger.warn("failed to read {}/system.reg", (Object)wineprefix, (Object)ex);
                    win32 = false;
                }
                if (win32) {
                    wine.setPrefix(wineprefix);
                } else {
                    logger.debug("wine environment {} has no 32-bit windows architecture", (Object)wineprefix);
                }
            }
        }
        logger.debug("use wine environment {}", (Object)wine.getPrefix());
    }

    protected File getEnvironmentVariableAsFile(String property) {
        String value = System.getenv(property);
        return value != null && !value.isEmpty() ? new File(value) : null;
    }
}

