/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.gradle.mql4.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.gradle.api.Project;

public class Wine {
    private static final Pattern DOS_DRIVE = Pattern.compile("[a-z]\\x3a");
    private final Project project;
    private String executable = "wine";
    private File prefix = null;
    private boolean enabled;

    public Wine(Project project) {
        this.project = project;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setExecutable(File executable) {
        this.executable = executable.getAbsolutePath();
    }

    public void setPrefix(File prefix) {
        block5: {
            File dosdevices = new File(prefix, "dosdevices");
            if (!dosdevices.isDirectory()) {
                this.prefix = prefix;
            } else {
                File[] drives;
                for (File drive : drives = dosdevices.listFiles(file -> {
                    String name = file.getName();
                    return DOS_DRIVE.matcher(name).matches() && Files.isSymbolicLink(file.toPath());
                })) {
                    try {
                        Path link = Files.readSymbolicLink(drive.toPath());
                        if (!"/".equals(link.toFile().getAbsolutePath())) continue;
                        this.prefix = prefix;
                        break block5;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.project.getLogger().warn("wine prefix {} does not contain a system wide drive!");
            }
        }
    }

    public void setPrefix(String prefix) {
        this.setPrefix(new File(prefix));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = Boolean.parseBoolean(enabled);
    }

    public String toString() {
        return "Wine(project=" + this.project + ", executable=" + this.getExecutable() + ", prefix=" + this.getPrefix() + ", enabled=" + this.isEnabled() + ")";
    }

    public String getExecutable() {
        return this.executable;
    }

    public File getPrefix() {
        return this.prefix;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

