/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.pack.detector;

import de.sayayi.lib.pack.PackConfig;
import de.sayayi.lib.pack.PackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.OptionalInt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileTypeDetector
extends FileTypeDetector {
    private final PackConfig packConfig;
    private final String mimeType;

    protected AbstractFileTypeDetector(@NotNull PackConfig packConfig, @NotNull String mimeType) {
        this.packConfig = packConfig;
        this.mimeType = mimeType;
    }

    @Override
    public String probeContentType(Path path) {
        String string;
        PackInputStream packStream = new PackInputStream(this.packConfig, Files.newInputStream(path, new OpenOption[0]));
        try {
            string = this.buildAnnotatedMimeType(packStream.getVersion(), packStream.isCompressed());
        }
        catch (Throwable throwable) {
            try {
                try {
                    packStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        packStream.close();
        return string;
    }

    @Contract(pure=true)
    @NotNull
    protected String buildAnnotatedMimeType(@NotNull OptionalInt version, Boolean compressed) {
        StringBuilder m = new StringBuilder(this.mimeType);
        if (version.isPresent()) {
            m.append(";version=").append(version.getAsInt());
        }
        if (compressed != null) {
            m.append(";compress=").append(compressed);
        }
        return m.toString();
    }
}

