/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.pack;

import de.sayayi.lib.pack.PackConfig;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class PackOutputStream
implements Closeable {
    @NotNull
    private OutputStream stream;
    private int bit = 7;
    private byte b;

    @Contract(mutates="param2,io")
    public PackOutputStream(boolean compress, @NotNull OutputStream stream) throws IOException {
        this(new PackConfig.Builder().withCompressionSupport().build(), compress, stream);
    }

    @Contract(mutates="param3,io")
    public PackOutputStream(@NotNull PackConfig packConfig, @Range(from=0L, to=0x7FFFFFFFL) int version, @NotNull OutputStream stream) throws IOException {
        this(packConfig, version, packConfig.isCompressionSupport(), stream);
    }

    @Contract(mutates="param2,io")
    public PackOutputStream(@NotNull PackConfig packConfig, @NotNull OutputStream stream) throws IOException {
        this(packConfig, packConfig.getLowestVersionNumber(), packConfig.isCompressionSupport(), stream);
    }

    @Contract(mutates="param3,io")
    public PackOutputStream(@NotNull PackConfig packConfig, boolean compress, @NotNull OutputStream stream) throws IOException {
        this(packConfig, packConfig.getLowestVersionNumber(), compress, stream);
    }

    @Contract(mutates="param4,io")
    public PackOutputStream(@NotNull PackConfig packConfig, @Range(from=0L, to=0x7FFFFFFFL) int version, boolean compress, @NotNull OutputStream stream) throws IOException {
        this.stream = stream;
        stream.write(packConfig.getMagic());
        if (packConfig.isCompressionSupport()) {
            this.writeBoolean(compress);
        } else if (compress) {
            throw new IllegalArgumentException("Compression is not supported");
        }
        int versionBits = packConfig.getVersionBits();
        if (versionBits != 0) {
            if (version < packConfig.getLowestVersionNumber() || version > packConfig.getHighestVersionNumber()) {
                throw new IllegalArgumentException("Invalid version number: " + version);
            }
            version -= packConfig.getLowestVersionNumber();
            if (versionBits <= 8) {
                this.writeSmallVar(version);
            } else {
                this.writeLarge(version, versionBits);
            }
        }
        if (compress) {
            this.forceByteAlignment();
            stream.flush();
            this.stream = new GZIPOutputStream(stream);
        }
    }

    @Contract(mutates="this,io")
    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.b = (byte)(this.b | (byte)(1 << this.bit));
        }
        if (this.bit-- == 0) {
            this.stream.write(this.b);
            this.bit = 7;
            this.b = 0;
        }
    }

    @Contract(mutates="this,io")
    public <T extends Enum<T>> void writeEnum(@NotNull T value, @Range(from=1L, to=16L) int bitWidth) throws IOException {
        if (bitWidth <= 0 || bitWidth > 16) {
            throw new IllegalArgumentException("Invalid bitWidth: " + bitWidth);
        }
        int ordinal = value.ordinal();
        if (ordinal >= 1 << bitWidth) {
            throw new IllegalArgumentException("Ordinal of enum '" + value.name() + "' exceeds bitWidth");
        }
        if (bitWidth <= 8) {
            this.writeSmall(value.ordinal(), bitWidth);
        } else {
            this.writeLarge(value.ordinal(), bitWidth);
        }
    }

    @Contract(mutates="this,io")
    public <T extends Enum<T>> void writeEnum(@NotNull T value) throws IOException {
        int n = ((Enum[])value.getClass().getEnumConstants()).length;
        this.writeEnum(value, Integer.bitCount(n | n >> 1 | n >> 2 | n >> 4 | n >> 8));
    }

    @Contract(mutates="this,io")
    public void writeUnsignedShort(@Range(from=0L, to=65535L) int value) throws IOException {
        this.writeLarge(value, 16);
    }

    @Contract(mutates="this,io")
    public void writeInt(int value) throws IOException {
        this.writeLarge(value, 32);
    }

    @Contract(mutates="this,io")
    public void writeLong(long value) throws IOException {
        this.writeLarge(value, 64);
    }

    @Contract(mutates="this,io")
    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeSmall(0, 2);
            return;
        }
        int stringLength = string.length();
        int utfLength = 0;
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if ((utfLength += c >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2)) <= 65535) continue;
            throw new IllegalArgumentException("String too large");
        }
        if (utfLength < 16) {
            this.writeSmall(0x10 | utfLength, 6);
        } else if (utfLength < 256) {
            this.writeLarge(0x200 | utfLength, 10);
        } else {
            this.writeSmall(3, 2);
            this.writeLarge(utfLength, 16);
        }
        if (utfLength > 0) {
            this.forceByteAlignment();
            byte[] bytes = new byte[utfLength];
            int utfIdx = 0;
            for (int charIdx = 0; charIdx < stringLength; ++charIdx) {
                char c = string.charAt(charIdx);
                if (c >= '\u0001' && c <= '\u007f') {
                    bytes[utfIdx++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    bytes[utfIdx++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytes[utfIdx++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytes[utfIdx++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                bytes[utfIdx++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[utfIdx++] = (byte)(0x80 | c & 0x3F);
            }
            this.stream.write(bytes);
        }
    }

    @Contract(mutates="this,io")
    public void writeSmallVar(@Range(from=0L, to=255L) int value) throws IOException {
        if (value <= 7) {
            this.writeSmall(value, 4);
        } else if (value <= 15) {
            this.writeSmall(0x10 | value - 8, 5);
        } else {
            this.writeLarge(0x300 | value, 10);
        }
    }

    @Contract(mutates="this,io")
    public void writeSmall(@Range(from=0L, to=255L) int value, @Range(from=1L, to=8L) int bitWidth) throws IOException {
        if (value >= 1 << bitWidth) {
            throw new IllegalArgumentException("value " + value + " occupies more than " + bitWidth + " bits");
        }
        int bitsRemaining = this.bit + 1 - bitWidth;
        if (bitsRemaining > 0) {
            this.b = (byte)(this.b | (byte)((value & (1 << bitWidth) - 1) << bitsRemaining));
            this.bit -= bitWidth;
        } else if (bitsRemaining == 0) {
            this.stream.write(this.b | value & (1 << bitWidth) - 1);
            this.b = 0;
            this.bit = 7;
        } else {
            this.stream.write(this.b | (byte)(value >>> -bitsRemaining) & (1 << this.bit + 1) - 1);
            this.b = (byte)(value << 8 + bitsRemaining & 0xFF);
            this.bit = 7 + bitsRemaining;
        }
    }

    @Contract(mutates="this,io")
    public void writeLarge(long value, @Range(from=9L, to=64L) int bitWidth) throws IOException {
        if (this.bit < 7) {
            int bitsLeft = this.bit + 1 - bitWidth;
            this.b = (byte)(this.b | (byte)((byte)(value >>> -bitsLeft) & (1 << this.bit + 1) - 1));
            this.stream.write(this.b);
            bitWidth -= this.bit + 1;
            this.b = 0;
            this.bit = 7;
        }
        while (bitWidth >= 8) {
            this.stream.write((byte)(value >>> (bitWidth -= 8)));
        }
        if (bitWidth > 0) {
            this.b = (byte)(value << 8 - bitWidth & 0xFFL);
            this.bit = 7 - bitWidth;
        }
    }

    @Contract(mutates="this,io")
    protected void forceByteAlignment() throws IOException {
        if (this.bit != 7) {
            this.stream.write(this.b);
            this.bit = 7;
            this.b = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.forceByteAlignment();
        this.stream.flush();
        this.stream.close();
    }
}

