/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.pack;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class PackConfig {
    protected final byte[] magic;
    protected final int lowestVersionNumber;
    protected final int versionBits;
    protected final boolean compressionSupport;

    protected PackConfig(byte @NotNull [] magic, int lowestVersionNumber, @Range(from=0L, to=31L) int versionBits, boolean compressionSupport) {
        this.magic = Objects.requireNonNull(magic);
        this.lowestVersionNumber = lowestVersionNumber;
        this.versionBits = versionBits;
        this.compressionSupport = compressionSupport;
    }

    @Contract(pure=true)
    public byte @NotNull [] getMagic() {
        return Arrays.copyOf(this.magic, this.magic.length);
    }

    @Contract(pure=true)
    public int getLowestVersionNumber() {
        return this.lowestVersionNumber;
    }

    @Contract(pure=true)
    public int getHighestVersionNumber() {
        return this.lowestVersionNumber + (int)((1L << this.versionBits) - 1L);
    }

    @Contract(pure=true)
    public @Range(from=0L, to=31L) int getVersionBits() {
        return this.versionBits;
    }

    @Contract(pure=true)
    public boolean isCompressionSupport() {
        return this.compressionSupport;
    }

    public static class Builder {
        private byte[] magic = new byte[0];
        private int lowestVersionNumber = 0;
        private int versionBits = 0;
        private boolean compressionSupport = false;

        @Contract(value="-> this")
        @NotNull
        public Builder noVersion() {
            this.lowestVersionNumber = 0;
            this.versionBits = 0;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder withMagic(byte @NotNull [] magic) {
            this.magic = Objects.requireNonNull(magic, "magic must not be null");
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder withMagic(@NotNull String magic) {
            return this.withMagic(magic.getBytes(StandardCharsets.US_ASCII));
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder withMagic(@NotNull String magic, @NotNull Charset charset) {
            return this.withMagic(magic.getBytes(charset));
        }

        @Contract(value="-> this")
        @NotNull
        public Builder withCompressionSupport() {
            return this.withCompressionSupport(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder withCompressionSupport(boolean compressionSupport) {
            this.compressionSupport = compressionSupport;
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder withVersionRange(int lowestVersion, int highestVersion) {
            if (lowestVersion < 0) {
                throw new IllegalArgumentException("lowestVersion must not be negative");
            }
            if (lowestVersion > highestVersion) {
                throw new IllegalArgumentException("lowestVersion must not be larger than highestVersion");
            }
            this.lowestVersionNumber = lowestVersion;
            int v = highestVersion - lowestVersion;
            v |= v >> 1;
            v |= v >> 2;
            v |= v >> 4;
            v |= v >> 8;
            v |= v >> 16;
            this.versionBits = Integer.bitCount(v);
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public PackConfig build() {
            return new PackConfig(this.magic, this.lowestVersionNumber, this.versionBits, this.compressionSupport);
        }
    }
}

