/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.pack.detector;

import de.sayayi.lib.pack.PackConfig;
import de.sayayi.lib.pack.PackInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.OptionalInt;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTikaDetector
implements Detector {
    protected final PackConfig packConfig;
    protected final MediaType mimeType;

    protected AbstractTikaDetector(@NotNull PackConfig packConfig, @NotNull String mimeType) {
        this.packConfig = packConfig;
        this.mimeType = MediaType.parse((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        block11: {
            if (input != null) {
                input.mark(this.packConfig.getMagic().length + 11 + this.packConfig.getVersionBits() / 8);
                try {
                    MediaType mediaType;
                    PackInputStream packStream = new PackInputStream(this.packConfig, input);
                    try {
                        mediaType = this.buildAnnotatedMimeType(packStream.getVersion(), packStream.isCompressed());
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                packStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            break block11;
                        }
                    }
                    packStream.close();
                    return mediaType;
                }
                finally {
                    input.reset();
                }
            }
        }
        return MediaType.OCTET_STREAM;
    }

    @Contract(pure=true)
    @NotNull
    protected MediaType buildAnnotatedMimeType(@NotNull OptionalInt version, Boolean compressed) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (version.isPresent()) {
            parameters.put("version", Integer.toString(version.getAsInt()));
        }
        if (compressed != null) {
            parameters.put("compress", Boolean.toString(compressed));
        }
        return new MediaType(this.mimeType, parameters);
    }
}

