/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage;

import de.sayayi.plugin.gradle.repackage.task.RepackageSpec;
import de.sayayi.plugin.gradle.repackage.task.RepackageTask;
import groovy.lang.Closure;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.internal.ClosureBackedAction;
import org.jetbrains.annotations.NotNull;

public abstract class RepackageExtension {
    @NotNull
    private final Project project;

    @NotNull
    public abstract Property<Boolean> getVerbose();

    public abstract DirectoryProperty getDestinationDir();

    @NotNull
    public FileCollection dependency(@NotNull String name, @NotNull Closure<RepackageSpec> configureClosure) {
        TaskProvider repackageTask = this.project.getTasks().register("repackage-" + name, RepackageTask.class, (Action)new ClosureBackedAction(configureClosure));
        repackageTask.configure(task -> {
            task.setGroup("repackage");
            task.getDestinationName().convention(name.endsWith(".jar") ? name : name + ".jar");
            task.setDescription("Repackage " + (String)task.getDestinationName().get());
        });
        return ((RepackageTask)repackageTask.get()).getOutputs().getFiles();
    }

    @Generated
    public RepackageExtension(@NotNull Project project) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        this.project = project;
    }
}

