/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.relocator;

import de.sayayi.plugin.gradle.repackage.relocator.Relocator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;

public class DefaultRelocator
implements Relocator {
    private final String pattern;
    private final String pathPattern;
    private final String relocatedPattern;
    private final String relocatedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;

    public DefaultRelocator(@NotNull String pattern, String relocatedPattern) {
        this(pattern, relocatedPattern, null, null);
    }

    public DefaultRelocator(@NotNull String pattern, String relocatedPattern, List<String> includes, List<String> excludes) {
        this.pattern = pattern.replace('/', '.');
        this.pathPattern = pattern.replace('.', '/');
        if (relocatedPattern != null) {
            this.relocatedPattern = relocatedPattern.replace('/', '.');
            this.relocatedPathPattern = relocatedPattern.replace('.', '/');
        } else {
            this.relocatedPattern = "hidden." + this.pattern;
            this.relocatedPathPattern = "hidden/" + this.pathPattern;
        }
        this.includes = DefaultRelocator.normalizePatterns(includes);
        this.excludes = DefaultRelocator.normalizePatterns(excludes);
    }

    @NotNull
    public DefaultRelocator include(@NotNull String pattern) {
        this.includes.addAll(DefaultRelocator.normalizePatterns(List.of(pattern)));
        return this;
    }

    @NotNull
    public DefaultRelocator exclude(@NotNull String pattern) {
        this.excludes.addAll(DefaultRelocator.normalizePatterns(List.of(pattern)));
        return this;
    }

    @NotNull
    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = new LinkedHashSet<String>();
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (pattern.startsWith("%regex[")) {
                    normalized.add(pattern);
                    continue;
                }
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*")) continue;
                normalized.add(classPattern.substring(0, classPattern.lastIndexOf(47)));
            }
        }
        return normalized;
    }

    private boolean isIncluded(@NotNull String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)path, (String)"/", (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(@NotNull String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (String)"/", (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(@NotNull String path) {
        boolean pathStartsWithPattern;
        if (path.length() < this.pathPattern.length()) {
            return false;
        }
        if (path.endsWith(".class")) {
            if (path.length() == 6) {
                return false;
            }
            path = path.substring(0, path.length() - 6);
        }
        boolean bl = pathStartsWithPattern = path.charAt(0) == '/' ? path.startsWith(this.pathPattern, 1) : path.startsWith(this.pathPattern);
        if (pathStartsWithPattern) {
            return this.isIncluded(path) && !this.isExcluded(path);
        }
        return false;
    }

    @Override
    public boolean canRelocateClass(@NotNull String className) {
        return className.indexOf(47) < 0 && this.canRelocatePath(className.replace('.', '/'));
    }

    @Override
    @NotNull
    public String relocatePath(@NotNull String path) {
        return path.replaceFirst(this.pathPattern, this.relocatedPathPattern);
    }

    @Override
    @NotNull
    public String relocateClass(@NotNull String className) {
        return className.replaceFirst(this.pattern, this.relocatedPattern);
    }

    @Input
    public String getPattern() {
        return this.pattern;
    }

    @Input
    public String getPathPattern() {
        return this.pathPattern;
    }

    @Input
    @Optional
    public String getRelocatedPattern() {
        return this.relocatedPattern;
    }

    @Input
    public String getRelocatedPathPattern() {
        return this.relocatedPathPattern;
    }

    @Input
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Input
    public Set<String> getExcludes() {
        return this.excludes;
    }
}

