/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.task;

import de.sayayi.plugin.gradle.repackage.relocator.Relocator;
import de.sayayi.plugin.gradle.repackage.task.RepackageCopyAction;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.commons.Remapper;

final class RelocatorRemapper
extends Remapper {
    private static final Pattern INTERNAL_CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+)");
    private final List<Relocator> relocators;

    @Contract(pure=true)
    boolean hasRelocators() {
        return !this.relocators.isEmpty();
    }

    public Object mapValue(Object object) {
        if (object instanceof String) {
            String name;
            String originalValue = name = (String)object;
            Object prefix = "";
            Matcher classMatcher = INTERNAL_CLASS_PATTERN.matcher(name);
            if (classMatcher.matches()) {
                prefix = classMatcher.group(1) + "L";
                name = classMatcher.group(2);
            }
            for (Relocator relocator : this.relocators) {
                if (relocator.canRelocateClass(name)) {
                    return (String)prefix + relocator.relocateClass(name);
                }
                if (!relocator.canRelocatePath(name)) continue;
                return (String)prefix + relocator.relocatePath(name);
            }
            return originalValue;
        }
        return super.mapValue(object);
    }

    public String map(String name) {
        if (name.startsWith("java/") || name.startsWith("javax/") || name.startsWith("jdk/")) {
            return null;
        }
        String originalValue = name;
        Object prefix = "";
        Matcher classMatcher = INTERNAL_CLASS_PATTERN.matcher(name);
        if (classMatcher.matches()) {
            prefix = classMatcher.group(1) + "L";
            name = classMatcher.group(2);
        }
        for (Relocator relocator : this.relocators) {
            if (!relocator.canRelocatePath(name)) continue;
            return (String)prefix + relocator.relocatePath(name);
        }
        return originalValue;
    }

    @Contract(pure=true)
    public String mapPath(@NotNull String path) {
        return this.map(path.substring(0, path.indexOf(46)));
    }

    @Contract(pure=true)
    public String mapPath(@NotNull RepackageCopyAction.RelativeArchivePath path) {
        return this.mapPath(path.getPathString());
    }

    @Generated
    public RelocatorRemapper(List<Relocator> relocators) {
        this.relocators = relocators;
    }
}

