/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.task;

import de.sayayi.plugin.gradle.repackage.relocator.Relocator;
import de.sayayi.plugin.gradle.repackage.task.RelocatorRemapper;
import de.sayayi.plugin.gradle.repackage.transformer.Transformer;
import de.sayayi.plugin.gradle.repackage.transformer.TransformerContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.util.StreamUtils;
import org.apache.tools.zip.Zip64Mode;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.ZipEntryCompression;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepackageCopyAction
implements CopyAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepackageCopyAction.class);
    private static final Pattern VERSIONS_PREFIX_PATTERN = Pattern.compile("^(META-INF/versions/\\d+/)(.*)");
    private final boolean verbose;
    private final File jarFile;
    private final ZipEntryCompression zipEntryCompression;
    private final List<Transformer> transformers;
    private final List<Relocator> relocators;
    private final PatternSet patternSet;
    private final Set<String> visitedDirectories = new HashSet<String>();
    private final Set<String> visitedFiles = new HashSet<String>();

    @NotNull
    public WorkResult execute(@NotNull CopyActionProcessingStream stream) {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(this.jarFile);){
            if (this.zipEntryCompression == ZipEntryCompression.STORED) {
                zipOutputStream.setMethod(0);
            } else if (this.zipEntryCompression == ZipEntryCompression.DEFLATED) {
                zipOutputStream.setMethod(8);
            }
            zipOutputStream.setUseZip64(Zip64Mode.AsNeeded);
            zipOutputStream.setEncoding("UTF8");
            stream.process((CopyActionProcessingStreamAction)new StreamAction(zipOutputStream));
            this.processTransformers(zipOutputStream);
        }
        catch (Exception ex) {
            throw new GradleException("Could not create repackaged jar '" + this.jarFile + "'", (Throwable)ex);
        }
        return WorkResults.didWork((boolean)true);
    }

    private void processTransformers(@NotNull ZipOutputStream zipOutputStream) throws IOException {
        for (Transformer transformer : this.transformers) {
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(zipOutputStream);
        }
    }

    @Generated
    RepackageCopyAction(boolean verbose, File jarFile, ZipEntryCompression zipEntryCompression, List<Transformer> transformers, List<Relocator> relocators, PatternSet patternSet) {
        this.verbose = verbose;
        this.jarFile = jarFile;
        this.zipEntryCompression = zipEntryCompression;
        this.transformers = transformers;
        this.relocators = relocators;
        this.patternSet = patternSet;
    }

    public static class ArchiveFileTreeElement
    implements FileTreeElement {
        @NotNull
        private final RelativeArchivePath archivePath;

        @Contract(pure=true)
        boolean isClassFile() {
            return this.archivePath.isClassFile();
        }

        @NotNull
        public File getFile() {
            throw new UnsupportedOperationException("getFile");
        }

        public boolean isDirectory() {
            return this.archivePath.entry.isDirectory();
        }

        public long getLastModified() {
            return this.archivePath.entry.getLastModifiedDate().getTime();
        }

        public long getSize() {
            return this.archivePath.entry.getSize();
        }

        @NotNull
        public InputStream open() {
            return null;
        }

        public void copyTo(@NotNull OutputStream outputStream) {
        }

        public boolean copyTo(@NotNull File file) {
            return false;
        }

        @NotNull
        public String getName() {
            return this.archivePath.getPathString();
        }

        @NotNull
        public String getPath() {
            return this.archivePath.getLastName();
        }

        @NotNull
        public RelativeArchivePath getRelativePath() {
            return this.archivePath;
        }

        public int getMode() {
            return this.archivePath.entry.getUnixMode();
        }

        @NotNull
        public FilePermissions getPermissions() {
            return new DefaultFilePermissions(this.getMode());
        }

        @NotNull
        public FileTreeElement asFileTreeElement() {
            return new DefaultFileTreeElement(null, new RelativePath(!this.isDirectory(), this.archivePath.getSegments()), null, null);
        }

        @Generated
        public ArchiveFileTreeElement(@NotNull RelativeArchivePath archivePath) {
            if (archivePath == null) {
                throw new NullPointerException("archivePath is marked non-null but is null");
            }
            this.archivePath = archivePath;
        }
    }

    public static class RelativeArchivePath
    extends RelativePath {
        private final ZipEntry entry;

        private RelativeArchivePath(@NotNull ZipEntry entry) {
            super(!entry.isDirectory(), entry.getName().split("/"));
            this.entry = entry;
        }

        boolean isClassFile() {
            return this.getLastName().endsWith(".class");
        }

        public RelativeArchivePath getParent() {
            String[] segments = this.getSegments();
            int segmentsCount = segments.length;
            if (segmentsCount <= 1) {
                return null;
            }
            return new RelativeArchivePath(new ZipEntry(String.join((CharSequence)"/", Arrays.copyOf(segments, segmentsCount - 1)) + "/"));
        }
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final ZipOutputStream jarOutputStream;
        private final RelocatorRemapper remapper;

        private StreamAction(ZipOutputStream jarOutputStream) {
            this.jarOutputStream = jarOutputStream;
            this.remapper = new RelocatorRemapper(RepackageCopyAction.this.relocators);
        }

        @Contract(pure=true)
        protected boolean isArchive(@NotNull FileCopyDetails fileDetails) {
            return fileDetails.getRelativePath().getPathString().endsWith(".jar");
        }

        @Contract(pure=true)
        protected boolean isClass(@NotNull FileCopyDetails fileDetails) {
            return "class".equals(FilenameUtils.getExtension((String)fileDetails.getPath()));
        }

        public void processFile(@NotNull FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir((FileCopyDetails)details);
            } else {
                this.visitFile((FileCopyDetails)details);
            }
        }

        private void visitDir(@NotNull FileCopyDetails dirDetails) {
            try {
                ZipEntry archiveEntry = new ZipEntry(dirDetails.getRelativePath().getPathString() + "/");
                archiveEntry.setTime(dirDetails.getLastModified());
                archiveEntry.setUnixMode(0x4000 | dirDetails.getPermissions().toUnixNumeric());
                this.jarOutputStream.putNextEntry(archiveEntry);
                this.jarOutputStream.closeEntry();
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", dirDetails, RepackageCopyAction.this.jarFile), (Throwable)ex);
            }
        }

        private void visitFile(@NotNull FileCopyDetails fileDetails) {
            if (RepackageCopyAction.this.verbose) {
                log.info("Source file: {}", (Object)fileDetails.getRelativePath());
            }
            if (!this.isArchive(fileDetails)) {
                try {
                    if (this.remapper.hasRelocators() && this.isClass(fileDetails)) {
                        this.remapClass(fileDetails);
                    }
                    if (this.isTransformable((FileTreeElement)fileDetails)) {
                        this.transform(fileDetails);
                    }
                    ZipEntry archiveEntry = new ZipEntry(this.safeMap(fileDetails.getRelativePath().getPathString()));
                    archiveEntry.setTime(fileDetails.getLastModified());
                    archiveEntry.setUnixMode(0x8000 | fileDetails.getPermissions().toUnixNumeric());
                    this.jarOutputStream.putNextEntry(archiveEntry);
                    fileDetails.copyTo((OutputStream)this.jarOutputStream);
                    this.jarOutputStream.closeEntry();
                }
                catch (Exception ex) {
                    throw new GradleException(String.format("Could not add %s to jar '%s'.", fileDetails, RepackageCopyAction.this.jarFile), (Throwable)ex);
                }
            } else {
                this.processArchive(fileDetails);
            }
        }

        private void processArchive(@NotNull FileCopyDetails fileDetails) {
            try (ZipFile archive = new ZipFile(fileDetails.getFile());){
                Spec patternSpec = RepackageCopyAction.this.patternSet.getAsSpec();
                StreamUtils.enumerationAsStream((Enumeration)archive.getEntries()).map(zipEntry -> new ArchiveFileTreeElement(new RelativeArchivePath((ZipEntry)zipEntry))).filter(archiveElement -> patternSpec.isSatisfiedBy((Object)archiveElement.asFileTreeElement()) && archiveElement.getRelativePath().isFile()).forEach(archiveElement -> this.visitArchiveFile((ArchiveFileTreeElement)archiveElement, archive));
            }
        }

        private void visitArchiveFile(@NotNull ArchiveFileTreeElement archiveFile, @NotNull ZipFile archive) {
            if (archiveFile.isClassFile() || !this.isTransformable(archiveFile)) {
                RelativeArchivePath archiveFilePath = archiveFile.getRelativePath();
                if (RepackageCopyAction.this.visitedFiles.add(archiveFilePath.getPathString())) {
                    if (!this.remapper.hasRelocators() || !archiveFile.isClassFile()) {
                        this.copyArchiveEntry(archiveFilePath, archive);
                    } else {
                        this.remapClass(archiveFilePath, archive);
                    }
                }
            } else {
                this.transform(archiveFile, archive);
            }
        }

        private void addParentDirectories(@Nullable RelativeArchivePath file) throws IOException {
            if (file == null) {
                return;
            }
            if (file.isFile()) {
                this.addParentDirectories(file.getParent());
            } else if (RepackageCopyAction.this.visitedDirectories.add(file.getPathString())) {
                this.addParentDirectories(file.getParent());
                this.jarOutputStream.putNextEntry(file.entry);
                this.jarOutputStream.closeEntry();
            }
        }

        private void remapClass(@NotNull RelativeArchivePath file, @NotNull ZipFile archive) throws IOException {
            if (file.isClassFile()) {
                this.addParentDirectories(new RelativeArchivePath(new ZipEntry(this.remapper.mapPath(file) + ".class")));
                ZipEntry zipEntry = file.entry;
                try (InputStream classInputStream = archive.getInputStream(zipEntry);){
                    this.remapClass(classInputStream, file.getPathString(), zipEntry.getTime());
                }
            }
        }

        private void remapClass(@NotNull FileCopyDetails fileCopyDetails) throws IOException {
            try (InputStream classInputStream = Files.newInputStream(fileCopyDetails.getFile().toPath(), new OpenOption[0]);){
                this.remapClass(classInputStream, fileCopyDetails.getPath(), fileCopyDetails.getLastModified());
            }
        }

        private void remapClass(@NotNull InputStream classInputStream, @NotNull String path, long lastModified) throws IOException {
            ClassWriter classWriter = new ClassWriter(0);
            try {
                new ClassReader(classInputStream).accept((ClassVisitor)new ClassRemapper((ClassVisitor)classWriter, (Remapper)this.remapper), 8);
            }
            catch (Throwable ex) {
                throw new GradleException("Error while remapping class file " + path, ex);
            }
            ZipEntry archiveEntry = new ZipEntry(this.mapClassPath(path));
            archiveEntry.setTime(lastModified);
            this.jarOutputStream.putNextEntry(archiveEntry);
            this.jarOutputStream.write(classWriter.toByteArray());
            this.jarOutputStream.closeEntry();
        }

        @Contract(pure=true)
        @NotNull
        private String mapClassPath(@NotNull String classPath) {
            Matcher versionsPrefixMatcher = VERSIONS_PREFIX_PATTERN.matcher(classPath);
            return (String)(versionsPrefixMatcher.matches() ? versionsPrefixMatcher.group(1) + this.remapper.mapPath(versionsPrefixMatcher.group(2)) : this.remapper.mapPath(classPath)) + ".class";
        }

        private void copyArchiveEntry(RelativeArchivePath archiveFile, ZipFile archive) throws IOException {
            ZipEntry entry = new ZipEntry(this.safeMap(archiveFile.entry.getName()));
            entry.setTime(archiveFile.entry.getTime());
            RelativeArchivePath mappedFile = new RelativeArchivePath(entry);
            this.addParentDirectories(mappedFile);
            this.jarOutputStream.putNextEntry(mappedFile.entry);
            try (InputStream entryInputStream = archive.getInputStream(archiveFile.entry);){
                IOUtils.copyLarge((InputStream)entryInputStream, (OutputStream)this.jarOutputStream);
            }
            this.jarOutputStream.closeEntry();
        }

        private void transform(@NotNull ArchiveFileTreeElement element, @NotNull ZipFile archive) throws IOException {
            try (InputStream archiveEntryInputStream = archive.getInputStream(element.getRelativePath().entry);){
                this.transformAndClose(element, archiveEntryInputStream);
            }
        }

        private void transform(FileCopyDetails details) throws IOException {
            try (InputStream fileInputStream = Files.newInputStream(details.getFile().toPath(), new OpenOption[0]);){
                this.transformAndClose((FileTreeElement)details, fileInputStream);
            }
        }

        private void transformAndClose(@NotNull FileTreeElement element, @NotNull InputStream inputStream) {
            String mappedPath = this.remapper.map(element.getRelativePath().getPathString());
            RepackageCopyAction.this.transformers.stream().filter(t -> t.canTransformResource(element)).forEach(t -> t.transform(new TransformerContext(mappedPath, inputStream, RepackageCopyAction.this.relocators)));
        }

        @Contract(pure=true)
        private boolean isTransformable(@NotNull FileTreeElement element) {
            return RepackageCopyAction.this.transformers.stream().anyMatch(t -> t.canTransformResource(element));
        }

        @Contract(pure=true)
        @NotNull
        private String safeMap(@NotNull String name) {
            String remappedName = this.remapper.map(name);
            return remappedName != null ? remappedName : name;
        }
    }
}

