/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.task;

import de.sayayi.plugin.gradle.repackage.RepackageExtension;
import de.sayayi.plugin.gradle.repackage.relocator.DefaultRelocator;
import de.sayayi.plugin.gradle.repackage.relocator.Relocator;
import de.sayayi.plugin.gradle.repackage.task.RepackageCopyAction;
import de.sayayi.plugin.gradle.repackage.task.RepackageSpec;
import de.sayayi.plugin.gradle.repackage.transformer.FilterResourceTransformer;
import de.sayayi.plugin.gradle.repackage.transformer.ServiceFileTransformer;
import de.sayayi.plugin.gradle.repackage.transformer.Transformer;
import de.sayayi.plugin.gradle.repackage.util.ClassUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.ZipEntryCompression;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.jetbrains.annotations.NotNull;

public abstract class RepackageTask
extends ConventionTask
implements RepackageSpec {
    private final DirectoryProperty destinationDirectory;
    private final ConfigurableFileCollection sourceFiles;
    private final List<Transformer> transformers = new ArrayList<Transformer>();
    private final List<Relocator> relocators = new ArrayList<Relocator>();
    private final PatternSet classFilterPatternSet = new PatternSet();
    private final FilterResourceTransformer filterResourceTransformer;
    private final ServiceFileTransformer serviceFileTransformer;

    public RepackageTask() {
        Project project = this.getProject();
        RepackageExtension repackageExtension = (RepackageExtension)project.getExtensions().getByType(RepackageExtension.class);
        this.sourceFiles = project.files(new Object[0]);
        this.destinationDirectory = repackageExtension.getDestinationDir();
        this.filterResourceTransformer = new FilterResourceTransformer();
        this.transformers.add(this.filterResourceTransformer);
        this.serviceFileTransformer = new ServiceFileTransformer();
        this.transformers.add(this.serviceFileTransformer);
        this.getVerbose().convention(repackageExtension.getVerbose());
        this.getEntryCompression().convention((Object)ZipEntryCompression.DEFLATED);
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected DocumentationRegistry getDocumentationRegistry() {
        throw new UnsupportedOperationException();
    }

    @Input
    public int getClassFilterHash() {
        return this.classFilterPatternSet.hashCode();
    }

    @Override
    @Input
    @NotNull
    public abstract Property<ZipEntryCompression> getEntryCompression();

    @Override
    @Input
    @NotNull
    public abstract Property<String> getDestinationName();

    @Override
    @Input
    @NotNull
    public abstract Property<Boolean> getVerbose();

    @InputFiles
    public FileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    @OutputFile
    public RegularFile getDestinationPath() {
        return (RegularFile)this.destinationDirectory.file(this.getDestinationName()).get();
    }

    @Override
    public void from(@NotNull FileCollection files) {
        this.sourceFiles.from(new Object[]{this.getProject().files(new Object[]{files.getFiles()})});
    }

    @Override
    public void from(@NotNull Dependency dependency) {
        this.from((FileCollection)this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency}));
    }

    @Override
    public void from(@NotNull String dependencyNotation, @NotNull Closure<?> configureClosure) {
        this.from(this.getProject().getDependencies().create((Object)Objects.requireNonNull(dependencyNotation), configureClosure));
    }

    @Override
    public void from(@NotNull String dependencyNotation) {
        this.from(this.getProject().getDependencies().create((Object)Objects.requireNonNull(dependencyNotation)));
    }

    @Override
    @NotNull
    public RepackageSpec relocate(@NotNull String pattern, String destination, Action<DefaultRelocator> configure) {
        this.addRelocator(new DefaultRelocator(pattern, destination), configure);
        return this;
    }

    @Override
    @NotNull
    public RepackageSpec relocate(@NotNull Relocator relocator) {
        this.addRelocator(relocator, null);
        return this;
    }

    private <R extends Relocator> void addRelocator(@NotNull R relocator, Action<R> configure) {
        if (configure != null) {
            configure.execute(relocator);
        }
        this.relocators.add(relocator);
    }

    @Nested
    @NotNull
    public List<Relocator> getRelocators() {
        return this.relocators;
    }

    @Override
    @NotNull
    public <T extends Transformer> RepackageSpec transform(@NotNull Class<T> transformerClass, Action<T> configure) throws ReflectiveOperationException {
        this.addTransform((Transformer)transformerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), configure);
        return this;
    }

    @Override
    @NotNull
    public RepackageSpec transform(@NotNull Transformer transformer) {
        this.addTransform(transformer, null);
        return this;
    }

    private <T extends Transformer> void addTransform(@NotNull T transformer, Action<T> configure) {
        if (configure != null) {
            configure.execute(transformer);
        }
        this.transformers.add(transformer);
    }

    @Nested
    @NotNull
    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @NotNull
    public RepackageSpec filterServices(@NotNull Action<ServiceFileTransformer> configure) {
        configure.execute((Object)this.serviceFileTransformer);
        return this;
    }

    @Override
    @NotNull
    public RepackageSpec filterResources(@NotNull Action<PatternFilterable> configure) {
        configure.execute((Object)this.filterResourceTransformer.getFilter());
        return this;
    }

    @Override
    @NotNull
    public RepackageSpec exclude(@NotNull String classnamePattern) {
        if (!ClassUtil.isClassnamePattern(classnamePattern)) {
            this.getLogger().error("exclusion classname pattern '{}' is not valid", (Object)classnamePattern);
        } else {
            this.classFilterPatternSet.exclude(new String[]{classnamePattern.replace('.', '/')});
        }
        return this;
    }

    @TaskAction
    public void run() {
        File repackagedJarFile = this.getDestinationPath().getAsFile();
        repackagedJarFile.getParentFile().mkdirs();
        if (((Boolean)this.getVerbose().get()).booleanValue()) {
            this.getLogger().info("Repackage to: {}", (Object)repackagedJarFile);
        }
        ObjectFactory objectFactory = this.getObjectFactory();
        DefaultCopySpec rootSpec = (DefaultCopySpec)objectFactory.newInstance(DefaultCopySpec.class, new Object[0]);
        rootSpec.setCaseSensitive(true);
        rootSpec.setIncludeEmptyDirs(false);
        rootSpec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        rootSpec.from(new Object[]{this.sourceFiles});
        CopyActionExecuter copyActionExecuter = new CopyActionExecuter(this.getInstantiator(), objectFactory, this.getFileSystem(), true, this.getDocumentationRegistry());
        RepackageCopyAction copyAction = new RepackageCopyAction((Boolean)this.getVerbose().get(), repackagedJarFile, (ZipEntryCompression)this.getEntryCompression().get(), this.transformers, this.relocators, this.classFilterPatternSet);
        this.setDidWork(copyActionExecuter.execute((CopySpecInternal)rootSpec, (CopyAction)copyAction).getDidWork());
    }
}

