/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.transformer;

import de.sayayi.plugin.gradle.repackage.relocator.Relocator;
import de.sayayi.plugin.gradle.repackage.transformer.Transformer;
import de.sayayi.plugin.gradle.repackage.transformer.TransformerContext;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ServiceFileTransformer
implements Transformer,
PatternFilterable {
    private final Map<String, List<String>> serviceEntries = new TreeMap<String, List<String>>();
    private final PatternSet servicesPatternSet = new PatternSet().include(new String[]{"META-INF/services/**"}).exclude(new String[]{"META-INF/services/org.codehaus.groovy.runtime.ExtensionModule"});
    private Spec<FileTreeElement> servicesSpec = null;
    private boolean stripComments = false;

    @NotNull
    private Spec<FileTreeElement> getServicesSpec() {
        if (this.servicesSpec == null) {
            this.servicesSpec = this.servicesPatternSet.getAsSpec();
        }
        return this.servicesSpec;
    }

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        return this.getServicesSpec().isSatisfiedBy((Object)element);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        List<String> lines = this.readLines(context.getInputStream());
        String targetPath = context.getPath();
        for (Relocator relocator : context.getRelocators()) {
            if (relocator.canRelocateClass(new File(targetPath).getName())) {
                targetPath = relocator.relocateClass(targetPath);
            }
            int l = lines.size();
            for (int n = 0; n < l; ++n) {
                Object comment;
                String line = lines.get(n);
                int hashIndex = line.indexOf(35);
                if (hashIndex == 0) continue;
                if (hashIndex > 0) {
                    comment = "  # " + line.substring(hashIndex + 1).trim();
                    line = line.substring(0, hashIndex).trim();
                } else {
                    comment = "";
                }
                if (!relocator.canRelocateClass(line)) continue;
                lines.set(n, relocator.relocateClass(line) + (String)comment);
            }
        }
        this.serviceEntries.computeIfAbsent(targetPath, p -> new ArrayList()).addAll(lines);
    }

    @Contract(pure=true)
    @NotNull
    private List<String> readLines(@NotNull InputStream inputStream) throws IOException {
        List lines = IOGroovyMethods.readLines((InputStream)inputStream);
        if (this.stripComments) {
            for (int n = 0; n < lines.size(); ++n) {
                String line = (String)lines.get(n);
                int hashIndex = line.indexOf(35);
                if (hashIndex <= 0) continue;
                lines.set(n, line.substring(0, hashIndex).trim());
            }
            lines.removeIf(this::isCommentOrEmptyLine);
        }
        return lines;
    }

    @Contract(pure=true)
    private boolean isCommentOrEmptyLine(@NotNull String line) {
        String trimmedLine = line.trim();
        return trimmedLine.isEmpty() || trimmedLine.startsWith("#");
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.serviceEntries.isEmpty();
    }

    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream zipOutputStream) throws IOException {
        for (Map.Entry<String, List<String>> serviceEntry : this.serviceEntries.entrySet()) {
            List<String> serviceLines = serviceEntry.getValue();
            if (serviceLines.isEmpty()) continue;
            ZipEntry zipEntry = new ZipEntry(serviceEntry.getKey());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(String.join((CharSequence)"\n", serviceLines).getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
        }
    }

    @Input
    public boolean isStripComments() {
        return this.stripComments;
    }

    @NotNull
    public ServiceFileTransformer stripComments(boolean stripComments) {
        this.stripComments = stripComments;
        return this;
    }

    @NotNull
    public ServiceFileTransformer include(String ... includes) {
        this.servicesPatternSet.include(includes);
        return this;
    }

    @NotNull
    public ServiceFileTransformer include(@NotNull Iterable<String> includes) {
        this.servicesPatternSet.include(includes);
        return this;
    }

    @NotNull
    public ServiceFileTransformer include(@NotNull Spec<FileTreeElement> includeSpec) {
        this.servicesPatternSet.include(includeSpec);
        return this;
    }

    @NotNull
    public ServiceFileTransformer include(@NotNull Closure includeSpec) {
        this.servicesPatternSet.include(includeSpec);
        return this;
    }

    @NotNull
    public ServiceFileTransformer exclude(String ... excludes) {
        this.servicesPatternSet.exclude(excludes);
        return this;
    }

    @NotNull
    public ServiceFileTransformer exclude(@NotNull Iterable<String> excludes) {
        this.servicesPatternSet.exclude(excludes);
        return this;
    }

    @NotNull
    public ServiceFileTransformer exclude(@NotNull Spec<FileTreeElement> excludeSpec) {
        this.servicesPatternSet.exclude(excludeSpec);
        return this;
    }

    @NotNull
    public ServiceFileTransformer exclude(@NotNull Closure excludeSpec) {
        this.servicesPatternSet.exclude(excludeSpec);
        return this;
    }

    @Input
    @NotNull
    public Set<String> getIncludes() {
        return this.servicesPatternSet.getIncludes();
    }

    @NotNull
    public ServiceFileTransformer setIncludes(@NotNull Iterable<String> includes) {
        this.servicesPatternSet.setIncludes(includes);
        return this;
    }

    @Input
    @NotNull
    public Set<String> getExcludes() {
        return this.servicesPatternSet.getExcludes();
    }

    @NotNull
    public ServiceFileTransformer setExcludes(@NotNull Iterable<String> excludes) {
        this.servicesPatternSet.setExcludes(excludes);
        return this;
    }
}

