/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.plugin.gradle.repackage.util;

import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClassUtil {
    private static final Set<String> KEYWORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");

    @Contract(pure=true)
    public static boolean isFullyQualifiedClassname(@NotNull String className) {
        for (String part : className.split("\\.", -1)) {
            if (KEYWORDS.contains(part) || part.isEmpty() || !Character.isJavaIdentifierStart(part.charAt(0))) {
                return false;
            }
            for (int i = 1; i < part.length(); ++i) {
                if (Character.isJavaIdentifierPart(part.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isClassnamePattern(@NotNull String classnamePattern) {
        return !classnamePattern.contains("***") && ClassUtil.isFullyQualifiedClassname(classnamePattern.replace('*', 'X'));
    }

    @Contract(pure=true)
    @NotNull
    public static Pattern createClassnamePatternPathRegex(@NotNull String classnamePattern) {
        StringBuilder regex = new StringBuilder("\\A");
        char[] patternChars = classnamePattern.toCharArray();
        int l = patternChars.length;
        block5: for (int n = 0; n < l; ++n) {
            char ch = patternChars[n];
            switch (ch) {
                case '*': {
                    if (n + 1 < l && patternChars[n + 1] == '*') {
                        ++n;
                        regex.append("(.*\\??)");
                        continue block5;
                    }
                    regex.append("([^/]+)");
                    continue block5;
                }
                case '$': {
                    regex.append("\\$");
                    continue block5;
                }
                case '.': {
                    ch = '/';
                }
                default: {
                    regex.append(ch);
                }
            }
        }
        return Pattern.compile(regex.append("\\Z").toString());
    }
}

