/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.samples;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.archive.tar.TarBZip2Driver;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarGZipDriver;
import de.schlichtherle.io.archive.zip.CheckedJarDriver;
import de.schlichtherle.io.archive.zip.CheckedReadOnlySfxDriver;
import de.schlichtherle.io.archive.zip.CheckedZipDriver;
import de.schlichtherle.io.samples.CommandLineUtility;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class NZip
extends CommandLineUtility {
    private static final String CLASS_NAME = "de.schlichtherle.io.samples.NZip";
    private static final ResourceBundle resources;
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private final FieldPosition fpos = new FieldPosition(0);
    static final /* synthetic */ boolean $assertionsDisabled;

    public NZip() {
    }

    public NZip(OutputStream out, OutputStream err, boolean autoFlush) {
        super(out, err, autoFlush);
    }

    protected DefaultArchiveDetector createDefaultArchiveDetector() {
        return new DefaultArchiveDetector(ArchiveDetector.ALL, new Object[]{"ear|jar|war", new CheckedJarDriver(), "zip", new CheckedZipDriver(), "exe", new CheckedReadOnlySfxDriver()});
    }

    protected DefaultArchiveDetector createDefaultArchiveDetector(String charset) {
        if (!$assertionsDisabled && charset == null) {
            throw new AssertionError();
        }
        return new DefaultArchiveDetector(ArchiveDetector.ALL, new Object[]{"ear|jar|war|zip", new CheckedZipDriver(charset), "exe", new CheckedReadOnlySfxDriver(charset), "tar", new TarDriver(charset), "tgz|tar.gz", new TarGZipDriver(charset), "tbz|tb2|tar.bz2", new TarBZip2Driver(charset)});
    }

    public static void main(String[] args) {
        System.exit(new NZip().run(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runWithException(String[] args) throws IllegalUsageException, IOException {
        block25: {
            if (args.length < 1) {
                throw new IllegalUsageException();
            }
            String cmd = args[0].toLowerCase(Locale.ENGLISH);
            args = NZip.lshift(args);
            ArchiveDetector oldDetector = File.getDefaultArchiveDetector();
            try {
                File.setDefaultArchiveDetector(this.createDefaultArchiveDetector());
                if ("ls".equals(cmd)) {
                    this.ls(args, false, false);
                    break block25;
                }
                if ("ll".equals(cmd)) {
                    this.ls(args, true, false);
                    break block25;
                }
                if ("llr".equals(cmd)) {
                    this.ls(args, true, true);
                    break block25;
                }
                if ("cat".equals(cmd)) {
                    this.cat(args);
                    break block25;
                }
                if ("cp".equals(cmd)) {
                    this.cpOrMv(args, false);
                    break block25;
                }
                if ("mv".equals(cmd)) {
                    this.cpOrMv(args, true);
                    break block25;
                }
                if ("touch".equals(cmd)) {
                    this.touch(args);
                    break block25;
                }
                if ("mkdir".equals(cmd)) {
                    this.mkdir(args, false);
                    break block25;
                }
                if ("mkdirs".equals(cmd)) {
                    this.mkdir(args, true);
                    break block25;
                }
                if ("rm".equals(cmd)) {
                    this.rm(args, false);
                    break block25;
                }
                if ("rmr".equals(cmd)) {
                    this.rm(args, true);
                    break block25;
                }
                if ("isarchive".equals(cmd)) {
                    boolean bl = this.isArchive(args);
                    return bl;
                }
                if ("isdirectory".equals(cmd)) {
                    boolean bl = this.isDirectory(args);
                    return bl;
                }
                if ("isfile".equals(cmd)) {
                    boolean bl = this.isFile(args);
                    return bl;
                }
                if ("exists".equals(cmd)) {
                    boolean bl = this.exists(args);
                    return bl;
                }
                if ("length".equals(cmd)) {
                    boolean bl = this.length(args);
                    return bl;
                }
                throw new IllegalUsageException();
            }
            finally {
                File.setDefaultArchiveDetector(oldDetector);
            }
        }
        return true;
    }

    private static final String[] lshift(String[] args) {
        return NZip.lshift(args, 1);
    }

    private static String[] lshift(String[] args, int num) {
        int rem = args.length - num;
        if (rem < 0) {
            throw new IllegalArgumentException();
        }
        String[] ret = new String[rem];
        System.arraycopy(args, num, ret, 0, rem);
        return ret;
    }

    private void ls(String[] args, boolean detailed, boolean recursive) throws IOException {
        if (args.length <= 0) {
            args = new String[]{"."};
        }
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            if (args.length > 1) {
                this.out.println(args[i] + ":");
            }
            if (file.isDirectory()) {
                this.ls(file, "", detailed, recursive);
                continue;
            }
            this.ls(file, file.getPath(), detailed, recursive);
        }
    }

    private void ls(java.io.File file, String path, boolean detailed, boolean recursive) throws IOException {
        if (file.isDirectory()) {
            java.io.File[] entries = file.listFiles();
            if (entries == null) {
                throw new IOException(path + " (" + resources.getString("ls.dia") + ")");
            }
            Arrays.sort(entries, FileTreeModel.FILE_NAME_COMPARATOR);
            for (int i = 0; i < entries.length; ++i) {
                java.io.File entry = entries[i];
                String entryPath = path.length() > 0 ? path + File.separator + entry.getName() : entry.getName();
                this.ls(entry, entryPath, detailed);
                if (!recursive || !entry.isDirectory()) continue;
                this.ls(entries[i], entryPath, detailed, true);
            }
        } else if (file.exists()) {
            this.ls(file, path, detailed);
        } else {
            throw new IOException(path + " (" + resources.getString("ls.nsfod") + ")");
        }
    }

    private void ls(java.io.File file, String path, boolean detailed) {
        StringBuffer buf = new StringBuffer();
        if (detailed) {
            this.align(buf, file.length(), 11);
            buf.append(' ');
            buf.append(this.dateFormat.format(new Date(file.lastModified())));
            buf.append(' ');
        }
        buf.append(path);
        if (detailed) {
            buf.append(file.isDirectory() ? File.separator : (file.isFile() ? "" : (file.exists() ? "?" : "\u2020")));
        }
        this.out.println(buf.toString());
    }

    private void align(StringBuffer buf, long number, int spacing) {
        int length = buf.length();
        this.numberFormat.format(number, buf, this.fpos);
        int i = spacing - this.fpos.getEndIndex();
        while (--i >= 0) {
            buf.insert(length, ' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cat(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            FileInputStream in = new FileInputStream(args[i]);
            try {
                File.cat(in, this.out);
                continue;
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    private void cpOrMv(String[] args, boolean mv) throws IOException {
        int srcI;
        if (args.length < 2) {
            throw new IllegalUsageException();
        }
        boolean unzip = false;
        boolean cp437out = false;
        boolean utf8out = false;
        boolean cp437in = false;
        boolean utf8in = false;
        int in = 0;
        int out = 0;
        for (srcI = 0; srcI < args.length && args[srcI].charAt(0) == '-'; ++srcI) {
            if (mv) {
                throw new IllegalUsageException();
            }
            String opt = args[srcI].toLowerCase(Locale.ENGLISH);
            if ("-unzip".equals(opt)) {
                unzip = true;
                ++out;
                continue;
            }
            if ("-cp437out".equals(opt)) {
                cp437out = true;
                ++out;
                continue;
            }
            if ("-utf8out".equals(opt)) {
                utf8out = true;
                ++out;
                continue;
            }
            if ("-cp437in".equals(opt)) {
                cp437in = true;
                ++in;
                continue;
            }
            if ("-utf8in".equals(opt)) {
                utf8in = true;
                ++in;
                continue;
            }
            throw new IllegalUsageException();
        }
        if (in > 1 || out > 1) {
            throw new IllegalUsageException();
        }
        ArchiveDetector srcDetector = cp437in ? this.createDefaultArchiveDetector("IBM437") : (utf8in ? this.createDefaultArchiveDetector("UTF-8") : File.getDefaultArchiveDetector());
        ArchiveDetector dstDetector = unzip ? ArchiveDetector.NULL : (cp437out ? this.createDefaultArchiveDetector("IBM437") : (utf8out ? this.createDefaultArchiveDetector("UTF-8") : File.getDefaultArchiveDetector()));
        int dstI = args.length - 1;
        File dst = new File(args[dstI], dstDetector);
        if (dstI - srcI < 1 || dstI - srcI > 1 && !dst.isArchive() && !dst.isDirectory()) {
            throw new IllegalUsageException();
        }
        if (dst.isArchive() || dst.isEntry()) {
            this.progressMonitor.start();
        }
        for (int i = srcI; i < dstI; ++i) {
            File src = new File(args[i], srcDetector);
            File tmp = dstI - srcI > 1 || dst.isDirectory() ? new File((java.io.File)dst, src.getName(), dstDetector) : dst;
            if (mv) {
                if ((!tmp.isFile() || tmp.delete()) && src.renameTo(tmp)) continue;
                throw new IOException(src + ": " + resources.getString("cpOrMv.cmt") + ": " + tmp);
            }
            if (src.archiveCopyAllTo(tmp, srcDetector, dstDetector)) continue;
            throw new IOException(src + ": " + resources.getString("cpOrMv.cct") + ": " + tmp + " (" + resources.getString("cpOrMv.co") + ")");
        }
    }

    private void touch(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            boolean ok = !file.exists() ? file.createNewFile() : file.setLastModified(System.currentTimeMillis());
            if (ok) continue;
            String msg = !file.exists() ? resources.getString("touch.ccf") : (file.isDirectory() ? resources.getString("touch.culmtod") : (file.isFile() ? resources.getString("touch.culmtof") : resources.getString("touch.culmtosfod")));
            throw new IOException(file.getPath() + " (" + msg + ")");
        }
    }

    private void mkdir(String[] args, boolean recursive) throws IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            boolean ok;
            File file = new File(args[i]);
            boolean bl = ok = recursive ? file.mkdirs() : file.mkdir();
            if (ok) continue;
            String msg = !file.exists() ? resources.getString("mkdir.ccd") : (file.isDirectory() ? resources.getString("mkdir.dea") : (file.isFile() ? resources.getString("mkdir.fea") : resources.getString("mkdir.sfodea")));
            throw new IOException(file.getPath() + " (" + msg + ")");
        }
    }

    private void rm(String[] args, boolean recursive) throws IOException {
        if (args.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < args.length; ++i) {
            boolean ok;
            File file = new File(args[i]);
            boolean bl = ok = recursive ? file.deleteAll() : file.delete();
            if (ok) continue;
            String msg = !file.exists() ? resources.getString("rm.nsfod") : (file.isDirectory() ? (file.list().length > 0 ? resources.getString("rm.dne") : resources.getString("rm.crd")) : (file.isFile() ? resources.getString("rm.crf") : resources.getString("rm.crsfod")));
            throw new IOException(file.getPath() + " (" + msg + ")");
        }
    }

    private boolean isArchive(String[] args) {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new File(args[0]).isArchive();
        this.out.println(success);
        return success;
    }

    private boolean isDirectory(String[] args) {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new File(args[0]).isDirectory();
        this.out.println(success);
        return success;
    }

    private boolean isFile(String[] args) {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new File(args[0]).isFile();
        this.out.println(success);
        return success;
    }

    private boolean exists(String[] args) {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        boolean success = new File(args[0]).exists();
        this.out.println(success);
        return success;
    }

    private boolean length(String[] args) {
        if (args.length != 1) {
            throw new IllegalUsageException();
        }
        long length = new File(args[0]).length();
        this.out.println(length);
        return true;
    }

    static {
        $assertionsDisabled = !NZip.class.desiredAssertionStatus();
        resources = ResourceBundle.getBundle(CLASS_NAME);
    }

    public class IllegalUsageException
    extends CommandLineUtility.IllegalUsageException {
        private IllegalUsageException() {
            super(resources.getString("usage"));
        }
    }
}

