/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file.nio;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.file.nio.FileEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FileController
extends FsController<FsModel> {
    private static final OpenOption[] RWD_OPTIONS = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC};
    private final FsModel model;
    private final Path target;

    FileController(FsModel model) {
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.target = Paths.get(model.getMountPoint().toUri());
    }

    private BasicFileAttributeView getBasicFileAttributeView(Path file) {
        return Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
    }

    public FsModel getModel() {
        return this.model;
    }

    public FsController<?> getParent() {
        return null;
    }

    public Icon getOpenIcon() throws IOException {
        return null;
    }

    public Icon getClosedIcon() throws IOException {
        return null;
    }

    public boolean isReadOnly() throws IOException {
        return false;
    }

    public FileEntry getEntry(FsEntryName name) throws IOException {
        FileEntry entry = new FileEntry(this.target, name);
        return Files.exists(entry.getPath(), new LinkOption[0]) ? entry : null;
    }

    public boolean isReadable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isReadable(file);
    }

    public boolean isWritable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isWritable(file);
    }

    public boolean isExecutable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isReadable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"})
    static boolean isCreatableOrWritable(Path file) {
        boolean bl;
        Files.createFile(file, new FileAttribute[0]);
        try {
            bl = FileController.isCreatableOrWritable(file);
        }
        catch (Throwable throwable) {
            try {
                try {
                    Files.delete(file);
                    throw throwable;
                }
                catch (FileAlreadyExistsException ex) {
                    if (Files.isWritable(file)) {
                        boolean ok;
                        long time = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                        if (0L > time) {
                            return false;
                        }
                        try {
                            Files.setLastModifiedTime(file, FileTime.fromMillis(time + 1L));
                        }
                        catch (IOException ex2) {
                            return false;
                        }
                        try {
                            SeekableByteChannel sbc = Files.newByteChannel(file, RWD_OPTIONS);
                            try {
                                boolean empty;
                                byte octet;
                                ByteBuffer buf = ByteBuffer.allocate(1);
                                if (-1 == sbc.read(buf)) {
                                    octet = 0;
                                    empty = true;
                                } else {
                                    octet = buf.get(0);
                                    empty = false;
                                }
                                sbc.position(0L);
                                buf.rewind();
                                sbc.write(buf);
                                try {
                                    sbc.position(0L);
                                    buf.rewind();
                                    sbc.read(buf);
                                    byte check = buf.get(0);
                                    ok = octet == check;
                                }
                                finally {
                                    if (empty) {
                                        sbc.truncate(0L);
                                    }
                                }
                            }
                            finally {
                                sbc.close();
                            }
                        }
                        finally {
                            try {
                                Files.setLastModifiedTime(file, FileTime.fromMillis(time));
                            }
                            catch (IOException ex2) {
                                ok = false;
                            }
                        }
                        return ok;
                    }
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
        }
        Files.delete(file);
        return bl;
    }

    public void setReadOnly(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        if (!file.toFile().setReadOnly()) {
            if (Files.exists(file, new LinkOption[0])) {
                throw new AccessDeniedException(file.toString());
            }
            throw new FileNotFoundException(file.toString());
        }
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        Path file = this.target.resolve(name.getPath());
        FileTime time = FileTime.fromMillis(value);
        this.getBasicFileAttributeView(file).setTimes(types.get((Enum)Entry.Access.WRITE) ? time : null, types.get((Enum)Entry.Access.READ) ? time : null, types.get((Enum)Entry.Access.CREATE) ? time : null);
        return types.clear((Enum)Entry.Access.WRITE).clear((Enum)Entry.Access.READ).clear((Enum)Entry.Access.CREATE).isEmpty();
    }

    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times) throws IOException {
        Path file = this.target.resolve(name.getPath());
        EnumMap<Entry.Access, Long> t = new EnumMap<Entry.Access, Long>(times);
        this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime((Long)t.remove(Entry.Access.WRITE)), FileController.toFileTime((Long)t.remove(Entry.Access.READ)), FileController.toFileTime((Long)t.remove(Entry.Access.CREATE)));
        return t.isEmpty();
    }

    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new FileEntry(this.target, name).getInputSocket();
    }

    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileEntry(this.target, name).getOutputSocket(options, template);
    }

    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        Path file = this.target.resolve(name.getPath());
        switch (type) {
            case FILE: {
                if (options.get((Enum)FsOutputOption.EXCLUSIVE)) {
                    Files.createFile(file, new FileAttribute[0]);
                    break;
                }
                Files.newOutputStream(file, new OpenOption[0]).close();
                break;
            }
            case DIRECTORY: {
                Files.createDirectory(file, new FileAttribute[0]);
                break;
            }
            default: {
                throw new IOException(file + " (entry type not supported: " + type + ")");
            }
        }
        if (null != template) {
            this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime(template.getTime(Entry.Access.WRITE)), FileController.toFileTime(template.getTime(Entry.Access.READ)), FileController.toFileTime(template.getTime(Entry.Access.CREATE)));
        }
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }

    public void unlink(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        Files.delete(file);
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
    }
}

