/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file.nio;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.file.nio.FileInputSocket;
import de.schlichtherle.truezip.fs.file.nio.FileOutputSocket;
import de.schlichtherle.truezip.fs.file.nio.TempFilePool;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Pool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
class FileEntry
extends FsEntry
implements IOEntry<FileEntry>,
Pool.Releasable<IOException> {
    private final Path path;
    private final String name;
    @CheckForNull
    volatile TempFilePool pool;

    FileEntry(Path path) {
        assert (null != path);
        this.path = path;
        this.name = path.toString();
    }

    FileEntry(Path path, FsEntryName name) {
        assert (null != path);
        this.path = path.resolve(name.getPath());
        this.name = name.toString();
    }

    private BasicFileAttributes readBasicFileAttributes() throws IOException {
        return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
    }

    public final FileEntry createTempFile() throws IOException {
        TempFilePool pool = this.pool;
        if (null == pool) {
            pool = this.pool = new TempFilePool(this.path.getParent());
        }
        return pool.allocate();
    }

    public void release() throws IOException {
    }

    final Path getPath() {
        return this.path;
    }

    public final String getName() {
        return this.name.replace(File.separatorChar, '/');
    }

    public final Set<Entry.Type> getTypes() {
        try {
            BasicFileAttributes attr = this.readBasicFileAttributes();
            if (attr.isRegularFile()) {
                return FILE_TYPE_SET;
            }
            if (attr.isDirectory()) {
                return DIRECTORY_TYPE_SET;
            }
            if (attr.isSymbolicLink()) {
                return SYMLINK_TYPE_SET;
            }
            if (attr.isOther()) {
                return SPECIAL_TYPE_SET;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET;
    }

    public final boolean isType(Entry.Type type) {
        try {
            switch (type) {
                case FILE: {
                    return this.readBasicFileAttributes().isRegularFile();
                }
                case DIRECTORY: {
                    return this.readBasicFileAttributes().isDirectory();
                }
                case SYMLINK: {
                    return this.readBasicFileAttributes().isSymbolicLink();
                }
                case SPECIAL: {
                    return this.readBasicFileAttributes().isOther();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public final long getSize(Entry.Size type) {
        try {
            return this.readBasicFileAttributes().size();
        }
        catch (IOException ignore) {
            return -1L;
        }
    }

    public final long getTime(Entry.Access type) {
        try {
            BasicFileAttributes attr = this.readBasicFileAttributes();
            switch (type) {
                case WRITE: {
                    return attr.lastModifiedTime().toMillis();
                }
                case READ: {
                    return attr.lastAccessTime().toMillis();
                }
                case CREATE: {
                    return attr.creationTime().toMillis();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Set<String> getMembers() {
        LinkedHashSet<String> linkedHashSet;
        DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Path member : stream) {
                result.add(member.getFileName().toString());
            }
            linkedHashSet = result;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ignore) {
                return null;
            }
        }
        stream.close();
        return linkedHashSet;
    }

    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, (BitField<FsOutputOption>)FsOutputOptions.NO_OUTPUT_OPTION, null);
    }

    final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileOutputSocket(this, options, template);
    }
}

