/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file.nio;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.nio.FileEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private static final int INITIAL_CAPACITY = FsOutputOption.values().length * 4 / 3;
    private static final StandardOpenOption[] WRITE_STANDARD_OPEN_OPTION = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry entry, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        assert (null != entry);
        assert (null != options);
        this.entry = entry;
        this.options = options;
        this.template = template;
    }

    public FileEntry getLocalTarget() {
        return this.entry;
    }

    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        final Path entryFile = this.entry.getPath();
        if (this.options.get((Enum)FsOutputOption.CREATE_PARENTS)) {
            Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
        }
        FileAlreadyExistsException exists = null;
        if (this.options.get((Enum)FsOutputOption.CACHE)) {
            try {
                Files.createFile(entryFile, new FileAttribute[0]);
                if (this.options.get((Enum)FsOutputOption.EXCLUSIVE)) {
                    throw new IOException(entryFile + " (file exists already)");
                }
            }
            catch (FileAlreadyExistsException ex) {
                exists = ex;
            }
        }
        final FileEntry temp = null != exists ? this.entry.createTempFile() : this.entry;
        final Path tempFile = temp.getPath();
        final HashSet<StandardOpenOption> set = new HashSet<StandardOpenOption>(INITIAL_CAPACITY);
        Collections.addAll(set, WRITE_STANDARD_OPEN_OPTION);
        if (this.options.get((Enum)FsOutputOption.APPEND)) {
            set.add(StandardOpenOption.APPEND);
        }
        if (this.options.get((Enum)FsOutputOption.EXCLUSIVE)) {
            set.add(StandardOpenOption.CREATE_NEW);
        }
        try {
            if (temp != this.entry && this.options.get((Enum)FsOutputOption.APPEND)) {
                IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
            }
            class SeekableByteChannel
            extends DecoratingSeekableByteChannel {
                boolean closed;

                SeekableByteChannel() throws IOException {
                    super(Files.newByteChannel(path, set2, new FileAttribute[0]));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void close() throws IOException {
                    IOException ex;
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        this.delegate.close();
                        ex = null;
                    }
                    catch (Throwable throwable) {
                        IOException ex2 = null;
                        try {
                            if (temp == FileOutputSocket.this.entry) throw throwable;
                            try {
                                try {
                                    Files.move(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                    throw throwable;
                                }
                                catch (IOException ex22) {
                                    Files.copy(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                }
                                throw throwable;
                            }
                            catch (IOException ex23) {
                                ex2 = ex23;
                                throw ex2;
                            }
                            finally {
                                try {
                                    temp.release();
                                }
                                catch (IOException ex24) {
                                    throw (IOException)ex24.initCause(ex2);
                                }
                            }
                        }
                        finally {
                            Entry template = FileOutputSocket.this.template;
                            if (null != template) {
                                try {
                                    Files.getFileAttributeView(entryFile, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
                                }
                                catch (IOException ex25) {
                                    throw (IOException)ex25.initCause(ex2);
                                }
                            }
                        }
                    }
                    try {
                        if (temp == FileOutputSocket.this.entry) return;
                        try {
                            try {
                                Files.move(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                return;
                            }
                            catch (IOException ex2) {
                                Files.copy(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            return;
                        }
                        catch (IOException ex2) {
                            ex = ex2;
                            throw ex;
                        }
                        finally {
                            try {
                                temp.release();
                            }
                            catch (IOException ex2) {
                                throw (IOException)ex2.initCause(ex);
                            }
                        }
                    }
                    finally {
                        Entry template = FileOutputSocket.this.template;
                        if (null != template) {
                            try {
                                Files.getFileAttributeView(entryFile, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
                            }
                            catch (IOException ex2) {
                                throw (IOException)ex2.initCause(ex);
                            }
                        }
                    }
                }
            }
            return new SeekableByteChannel();
        }
        catch (IOException cause) {
            if (temp != this.entry) {
                try {
                    temp.release();
                }
                catch (IOException ex) {
                    throw (IOException)ex.initCause(cause);
                }
            }
            throw cause;
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public OutputStream newOutputStream() throws IOException {
        final Path entryFile = this.entry.getPath();
        if (this.options.get((Enum)FsOutputOption.CREATE_PARENTS)) {
            Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
        }
        FileAlreadyExistsException exists = null;
        if (this.options.get((Enum)FsOutputOption.CACHE)) {
            try {
                Files.createFile(entryFile, new FileAttribute[0]);
                if (this.options.get((Enum)FsOutputOption.EXCLUSIVE)) {
                    throw new IOException(entryFile + " (file exists already)");
                }
            }
            catch (FileAlreadyExistsException ex) {
                exists = ex;
            }
        }
        final FileEntry temp = null != exists ? this.entry.createTempFile() : this.entry;
        final Path tempFile = temp.getPath();
        final HashSet<StandardOpenOption> set = new HashSet<StandardOpenOption>(INITIAL_CAPACITY);
        Collections.addAll(set, WRITE_STANDARD_OPEN_OPTION);
        if (this.options.get((Enum)FsOutputOption.APPEND)) {
            set.add(StandardOpenOption.APPEND);
        }
        if (this.options.get((Enum)FsOutputOption.EXCLUSIVE)) {
            set.add(StandardOpenOption.CREATE_NEW);
        }
        try {
            if (temp != this.entry && this.options.get((Enum)FsOutputOption.APPEND)) {
                IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
            }
            class OutputStream
            extends DecoratingOutputStream {
                boolean closed;

                OutputStream() throws IOException {
                    super(Files.newOutputStream(path, set2.toArray(new StandardOpenOption[set2.size()])));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void close() throws IOException {
                    IOException ex;
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        this.delegate.close();
                        ex = null;
                    }
                    catch (Throwable throwable) {
                        IOException ex2 = null;
                        try {
                            if (temp == FileOutputSocket.this.entry) throw throwable;
                            try {
                                try {
                                    Files.move(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                    throw throwable;
                                }
                                catch (IOException ex22) {
                                    Files.copy(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                }
                                throw throwable;
                            }
                            catch (IOException ex23) {
                                ex2 = ex23;
                                throw ex2;
                            }
                            finally {
                                try {
                                    temp.release();
                                }
                                catch (IOException ex24) {
                                    throw (IOException)ex24.initCause(ex2);
                                }
                            }
                        }
                        finally {
                            Entry template = FileOutputSocket.this.template;
                            if (null != template) {
                                try {
                                    Files.getFileAttributeView(entryFile, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
                                }
                                catch (IOException ex25) {
                                    throw (IOException)ex25.initCause(ex2);
                                }
                            }
                        }
                    }
                    try {
                        if (temp == FileOutputSocket.this.entry) return;
                        try {
                            try {
                                Files.move(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                                return;
                            }
                            catch (IOException ex2) {
                                Files.copy(tempFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            return;
                        }
                        catch (IOException ex2) {
                            ex = ex2;
                            throw ex;
                        }
                        finally {
                            try {
                                temp.release();
                            }
                            catch (IOException ex2) {
                                throw (IOException)ex2.initCause(ex);
                            }
                        }
                    }
                    finally {
                        Entry template = FileOutputSocket.this.template;
                        if (null != template) {
                            try {
                                Files.getFileAttributeView(entryFile, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
                            }
                            catch (IOException ex2) {
                                throw (IOException)ex2.initCause(ex);
                            }
                        }
                    }
                }
            }
            return new OutputStream();
        }
        catch (IOException cause) {
            if (temp != this.entry) {
                try {
                    temp.release();
                }
                catch (IOException ex) {
                    throw (IOException)ex.initCause(cause);
                }
            }
            throw cause;
        }
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }
}

